/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.routing.UMORouter;
import org.mule.umo.routing.UMORouterCatchAllStrategy;
import org.mule.umo.routing.UMORouterCollection;

public abstract class AbstractRouterCollection
implements UMORouterCollection,
Initialisable {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected boolean matchAll = false;
    protected List routers = new CopyOnWriteArrayList();
    private RouterStatistics statistics;
    private UMORouterCatchAllStrategy catchAllStrategy;

    public AbstractRouterCollection(int type) {
        this.statistics = new RouterStatistics(type);
    }

    public void initialise() throws InitialisationException {
        Iterator iterator = this.routers.iterator();
        while (iterator.hasNext()) {
            UMORouter router = (UMORouter)iterator.next();
            router.initialise();
        }
    }

    public void dispose() {
        Iterator iterator = this.routers.iterator();
        while (iterator.hasNext()) {
            UMORouter router = (UMORouter)iterator.next();
            router.dispose();
        }
    }

    public void setRouters(List routers) {
        Iterator iterator = routers.iterator();
        while (iterator.hasNext()) {
            this.addRouter((UMORouter)iterator.next());
        }
    }

    public void addRouter(UMORouter router) {
        router.setRouterStatistics(this.getStatistics());
        this.routers.add(router);
    }

    public UMORouter removeRouter(UMORouter router) {
        if (this.routers.remove(router)) {
            return router;
        }
        return null;
    }

    public List getRouters() {
        return this.routers;
    }

    public UMORouterCatchAllStrategy getCatchAllStrategy() {
        return this.catchAllStrategy;
    }

    public void setCatchAllStrategy(UMORouterCatchAllStrategy catchAllStrategy) {
        this.catchAllStrategy = catchAllStrategy;
        if (this.catchAllStrategy != null && catchAllStrategy instanceof AbstractCatchAllStrategy) {
            ((AbstractCatchAllStrategy)this.catchAllStrategy).setStatistics(this.statistics);
        }
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public RouterStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(RouterStatistics stat) {
        this.statistics = stat;
    }
}

