/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.model.DefaultModelServiceDescriptor;
import org.mule.providers.service.DefaultTransportServiceDescriptor;
import org.mule.providers.service.TransportServiceDescriptor;
import org.mule.registry.AbstractServiceDescriptor;
import org.mule.registry.ServiceDescriptor;
import org.mule.registry.ServiceException;
import org.mule.registry.ServiceFinder;
import org.mule.util.ClassUtils;
import org.mule.util.SpiUtils;
import org.springframework.context.ApplicationContext;

public class ServiceDescriptorFactory {
    public static final String PROVIDER_SERVICE_TYPE = "transport";
    public static final String MODEL_SERVICE_TYPE = "model";
    public static final String EXCEPTION_SERVICE_TYPE = "exception";

    public static ServiceDescriptor create(String type, String name, Properties props, Properties overrides, ApplicationContext context) throws ServiceException {
        String serviceFinderClass = null;
        if (overrides != null) {
            serviceFinderClass = (String)props.remove("service.finder");
            props.putAll((Map<?, ?>)overrides);
        }
        AbstractServiceDescriptor sd = null;
        if (type.equals(PROVIDER_SERVICE_TYPE)) {
            try {
                sd = new DefaultTransportServiceDescriptor(name, props, context);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            props = SpiUtils.findServiceDescriptor(EXCEPTION_SERVICE_TYPE, name + "-exception-mappings");
            ((TransportServiceDescriptor)((Object)sd)).setExceptionMappings(props);
        } else if (type.equals(MODEL_SERVICE_TYPE)) {
            sd = new DefaultModelServiceDescriptor(name, props);
        } else {
            throw new ServiceException(CoreMessages.unrecognisedServiceType(type));
        }
        if (StringUtils.isNotBlank((String)serviceFinderClass)) {
            ServiceFinder finder;
            try {
                finder = (ServiceFinder)ClassUtils.instanciateClass(serviceFinderClass, ClassUtils.NO_ARGS);
            }
            catch (Exception e) {
                throw new ServiceException(CoreMessages.cannotInstanciateFinder(serviceFinderClass), (Throwable)e);
            }
            String realService = finder.findService(name, sd, props);
            if (realService != null) {
                return RegistryContext.getRegistry().lookupServiceDescriptor(PROVIDER_SERVICE_TYPE, realService, overrides);
            }
            throw new ServiceException(CoreMessages.serviceFinderCantFindService(name));
        }
        return sd;
    }
}

