/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.providers.AbstractConnector;
import org.mule.providers.service.TransportFactoryException;
import org.mule.providers.service.TransportServiceDescriptor;
import org.mule.registry.ServiceException;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.BeanUtils;
import org.mule.util.MuleObjectHelper;
import org.mule.util.ObjectNameHelper;
import org.mule.util.PropertiesUtils;

public class TransportFactory {
    protected static final Log logger = LogFactory.getLog((Class)TransportFactory.class);
    public static final int GET_OR_CREATE_CONNECTOR = 0;
    public static final int ALWAYS_CREATE_CONNECTOR = 1;
    public static final int NEVER_CREATE_CONNECTOR = 2;
    public static final int USE_CONNECTOR = 3;

    public static UMOEndpoint createEndpoint(UMOEndpointURI uri, String type) throws EndpointException {
        UMOConnector connector;
        String scheme = uri.getFullScheme();
        try {
            if (uri.getCreateConnector() == 1) {
                connector = TransportFactory.createConnector(uri);
            } else if (uri.getCreateConnector() == 2) {
                connector = TransportFactory.getConnectorByProtocol(scheme);
            } else if (uri.getConnectorName() != null) {
                connector = RegistryContext.getRegistry().lookupConnector(uri.getConnectorName());
                if (connector == null) {
                    throw new TransportFactoryException(CoreMessages.objectNotRegistered("Connector", uri.getConnectorName()));
                }
            } else {
                connector = TransportFactory.getConnectorByProtocol(scheme);
                if (connector == null) {
                    connector = TransportFactory.createConnector(uri);
                }
            }
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
        if (connector == null) {
            Message m = CoreMessages.failedToCreateObjectWith("Endpoint", "Uri: " + uri);
            m.setNextMessage(CoreMessages.objectIsNull("connector"));
            throw new TransportFactoryException(m);
        }
        MuleEndpoint endpoint = new MuleEndpoint();
        endpoint.setConnector(connector);
        endpoint.setEndpointURI(uri);
        if (uri.getEndpointName() != null) {
            endpoint.setName(uri.getEndpointName());
        }
        if (type != null) {
            endpoint.setType(type);
            UMOTransformer trans = TransportFactory.getTransformer(uri, connector, "receiver".equals(type) ? 0 : 1);
            endpoint.setTransformer(trans);
            if ("receiver".equals(type)) {
                trans = TransportFactory.getTransformer(uri, connector, 2);
                endpoint.setResponseTransformer(trans);
            }
        }
        try {
            RegistryContext.getRegistry().registerEndpoint(endpoint);
        }
        catch (UMOException e) {
            throw new TransportFactoryException(e);
        }
        return endpoint;
    }

    private static UMOTransformer getTransformer(UMOEndpointURI url, UMOConnector cnn, int type) throws TransportFactoryException {
        try {
            UMOTransformer trans = null;
            String transId = null;
            transId = type == 2 ? url.getResponseTransformers() : url.getTransformers();
            if (transId != null) {
                trans = MuleObjectHelper.getTransformer(transId, ",");
            } else {
                Map so;
                Properties overrides = new Properties();
                if (cnn instanceof AbstractConnector && (so = ((AbstractConnector)cnn).getServiceOverrides()) != null) {
                    overrides.putAll((Map<?, ?>)so);
                }
                String scheme = url.getSchemeMetaInfo();
                TransportServiceDescriptor sd = (TransportServiceDescriptor)RegistryContext.getRegistry().lookupServiceDescriptor("transport", scheme, overrides);
                if (sd != null) {
                    trans = type == 0 ? sd.createInboundTransformer() : (type == 1 ? sd.createOutboundTransformer() : sd.createResponseTransformer());
                    if (trans != null) {
                        trans.initialise();
                    }
                } else {
                    throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
                }
            }
            return trans;
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
    }

    public static UMOConnector createConnector(UMOEndpointURI url) throws TransportFactoryException {
        try {
            String scheme = url.getSchemeMetaInfo();
            TransportServiceDescriptor sd = (TransportServiceDescriptor)RegistryContext.getRegistry().lookupServiceDescriptor("transport", scheme, null);
            if (sd == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
            }
            UMOConnector connector = sd.createConnector();
            if (connector != null) {
                if (connector instanceof AbstractConnector) {
                    ((AbstractConnector)connector).initialiseFromUrl(url);
                }
            } else {
                throw new TransportFactoryException(CoreMessages.objectNotSetInService("Connector", scheme));
            }
            connector.setName(ObjectNameHelper.getConnectorName(connector));
            Map props = new HashMap();
            PropertiesUtils.getPropertiesWithPrefix(RegistryContext.getRegistry().lookupProperties(), connector.getProtocol().toLowerCase(), props);
            if (props.size() > 0) {
                props = PropertiesUtils.removeNamespaces(props);
                BeanUtils.populateWithoutFail(connector, props, true);
            }
            RegistryContext.getRegistry().registerConnector(connector);
            return connector;
        }
        catch (Exception e) {
            throw new TransportFactoryException(CoreMessages.failedToCreateObjectWith("Endpoint", url), (Throwable)e);
        }
    }

    public static UMOConnector getOrCreateConnectorByProtocol(UMOEndpointURI uri) throws TransportFactoryException {
        return TransportFactory.getOrCreateConnectorByProtocol(uri, uri.getCreateConnector());
    }

    public static UMOConnector getOrCreateConnectorByProtocol(UMOImmutableEndpoint endpoint) throws TransportFactoryException {
        return TransportFactory.getOrCreateConnectorByProtocol(endpoint.getEndpointURI(), endpoint.getCreateConnector());
    }

    private static UMOConnector getOrCreateConnectorByProtocol(UMOEndpointURI uri, int create) throws TransportFactoryException {
        UMOConnector connector;
        String connectorName = uri.getConnectorName();
        if (null != connectorName && (connector = RegistryContext.getRegistry().lookupConnector(connectorName)) != null) {
            return connector;
        }
        connector = TransportFactory.getConnectorByProtocol(uri.getFullScheme());
        if (1 == create || connector == null && create == 0) {
            connector = TransportFactory.createConnector(uri);
            try {
                BeanUtils.populate((Object)connector, (Map)uri.getParams());
            }
            catch (Exception e) {
                throw new TransportFactoryException(CoreMessages.failedToSetPropertiesOn("Connector"), (Throwable)e);
            }
        } else if (create == 2 && connector == null) {
            logger.warn((Object)("There is no connector for protocol: " + uri.getScheme() + " and 'createConnector' is set to NEVER.  Returning null"));
        }
        return connector;
    }

    public static UMOConnector getConnectorByProtocol(String protocol) {
        UMOConnector resultConnector = null;
        Map connectors = RegistryContext.getRegistry().getConnectors();
        Iterator iterator = connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector connector = (UMOConnector)iterator.next();
            if (!connector.supportsProtocol(protocol)) continue;
            if (resultConnector == null) {
                resultConnector = connector;
                continue;
            }
            throw new IllegalStateException(CoreMessages.moreThanOneConnectorWithProtocol(protocol).getMessage());
        }
        return resultConnector;
    }
}

