/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.resource.spi.work.Work;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.CreateException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.ObjectUtils;

public abstract class AbstractPollingMessageReceiver
extends AbstractMessageReceiver
implements Work {
    public static final long DEFAULT_POLL_FREQUENCY = 1000L;
    public static final TimeUnit DEFAULT_POLL_TIMEUNIT = TimeUnit.MILLISECONDS;
    public static final long DEFAULT_STARTUP_DELAY = 1000L;
    private long frequency = 1000L;
    private TimeUnit timeUnit = DEFAULT_POLL_TIMEUNIT;
    protected final List schedules = new LinkedList();

    public AbstractPollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws CreateException {
        super(connector, component, endpoint);
    }

    public AbstractPollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, long frequency) throws CreateException {
        this(connector, component, endpoint);
        this.setFrequency(frequency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws UMOException {
        try {
            List list = this.schedules;
            synchronized (list) {
                ScheduledFuture schedule = this.connector.getScheduler().scheduleWithFixedDelay((Runnable)((Object)this), 1000L, this.getFrequency(), this.getTimeUnit());
                this.schedules.add(schedule);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(ObjectUtils.identityToShortString(this) + " scheduled " + ObjectUtils.identityToShortString(schedule) + " with " + this.frequency + "ms polling frequency"));
                }
            }
        }
        catch (Exception ex) {
            this.stop();
            throw new CreateException(CoreMessages.failedToScheduleWork(), ex, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws UMOException {
        List list = this.schedules;
        synchronized (list) {
            Iterator i = this.schedules.iterator();
            while (i.hasNext()) {
                ScheduledFuture schedule = (ScheduledFuture)i.next();
                schedule.cancel(false);
                i.remove();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)(ObjectUtils.identityToShortString(this) + " cancelled polling schedule: " + ObjectUtils.identityToShortString(schedule)));
            }
        }
    }

    public void run() {
        if (!this.stopped.get()) {
            try {
                this.connected.whenTrue(null);
                this.poll();
            }
            catch (InterruptedException e) {
                this.stop();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    public void release() {
        this.stop();
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long value) {
        this.frequency = value <= 0L ? 1000L : value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public abstract void poll() throws Exception;
}

