/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.RegistryContext;
import org.mule.config.MuleConfiguration;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ManagementContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.internal.notifications.AdminNotification;
import org.mule.impl.internal.notifications.AdminNotificationListener;
import org.mule.impl.internal.notifications.ComponentNotification;
import org.mule.impl.internal.notifications.ComponentNotificationListener;
import org.mule.impl.internal.notifications.ConnectionNotification;
import org.mule.impl.internal.notifications.ConnectionNotificationListener;
import org.mule.impl.internal.notifications.CustomNotification;
import org.mule.impl.internal.notifications.CustomNotificationListener;
import org.mule.impl.internal.notifications.ExceptionNotification;
import org.mule.impl.internal.notifications.ExceptionNotificationListener;
import org.mule.impl.internal.notifications.ManagementNotification;
import org.mule.impl.internal.notifications.ManagementNotificationListener;
import org.mule.impl.internal.notifications.ManagerNotification;
import org.mule.impl.internal.notifications.ManagerNotificationListener;
import org.mule.impl.internal.notifications.ModelNotification;
import org.mule.impl.internal.notifications.ModelNotificationListener;
import org.mule.impl.internal.notifications.RegistryNotification;
import org.mule.impl.internal.notifications.RegistryNotificationListener;
import org.mule.impl.internal.notifications.SecurityNotification;
import org.mule.impl.internal.notifications.SecurityNotificationListener;
import org.mule.impl.internal.notifications.ServerNotificationManager;
import org.mule.impl.internal.notifications.TransactionNotification;
import org.mule.impl.internal.notifications.TransactionNotificationListener;
import org.mule.impl.lifecycle.ContainerManagedLifecyclePhase;
import org.mule.impl.lifecycle.GenericLifecycleManager;
import org.mule.impl.lifecycle.phases.ManagementContextStartPhase;
import org.mule.impl.lifecycle.phases.ManagementContextStopPhase;
import org.mule.impl.lifecycle.phases.TransientRegistryDisposePhase;
import org.mule.impl.lifecycle.phases.TransientRegistryInitialisePhase;
import org.mule.impl.model.ModelServiceDescriptor;
import org.mule.impl.registry.AbstractRegistry;
import org.mule.impl.registry.ManagementContextDependencyProcessor;
import org.mule.impl.registry.ObjectProcessor;
import org.mule.impl.security.MuleSecurityManager;
import org.mule.impl.work.MuleWorkManager;
import org.mule.registry.AbstractServiceDescriptor;
import org.mule.registry.ServiceDescriptor;
import org.mule.registry.ServiceDescriptorFactory;
import org.mule.registry.ServiceException;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.UMOLifecycleManager;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.registry.RegistryFacade;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.BeanUtils;
import org.mule.util.SpiUtils;
import org.mule.util.UUID;
import org.mule.util.queue.CachingPersistenceStrategy;
import org.mule.util.queue.MemoryPersistenceStrategy;
import org.mule.util.queue.TransactionalQueueManager;

public class TransientRegistry
extends AbstractRegistry {
    protected final transient Log logger = LogFactory.getLog((Class)TransientRegistry.class);
    public static final String REGISTRY_ID = "org.mule.Registry.Transient";
    protected static Map sdCache = new HashMap();
    private Map registry;
    private MuleConfiguration config;

    public TransientRegistry() {
        super(REGISTRY_ID);
        this.init();
    }

    public TransientRegistry(RegistryFacade parent) {
        super(REGISTRY_ID, parent);
        this.init();
    }

    private void init() {
        this.registry = new HashMap(8);
        this.getObjectTypeMap(ObjectProcessor.class).put("_muleManagementContextProcessor", new ManagementContextDependencyProcessor());
    }

    protected UMOLifecycleManager createLifecycleManager() {
        GenericLifecycleManager lcm = new GenericLifecycleManager();
        TransientRegistryInitialisePhase initPhase = new TransientRegistryInitialisePhase();
        initPhase.setRegistryScope(0);
        lcm.registerLifecycle(initPhase);
        TransientRegistryDisposePhase disposePhase = new TransientRegistryDisposePhase();
        disposePhase.setRegistryScope(0);
        lcm.registerLifecycle(disposePhase);
        return lcm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialise() throws InitialisationException {
        int oldScope = this.getDefaultScope();
        this.setDefaultScope(0);
        try {
            this.applyProcessors(this.getConnectors());
            this.applyProcessors(this.getTransformers());
            this.applyProcessors(this.getEndpoints());
            this.applyProcessors(this.getAgents());
            this.applyProcessors(this.getModels());
            this.applyProcessors(this.getServices());
            this.applyProcessors(this.lookupCollection(Object.class));
            this.getManagementContext().fireNotification(new RegistryNotification((RegistryFacade)this, 1002));
        }
        finally {
            this.setDefaultScope(oldScope);
        }
    }

    protected void applyProcessors(Map objects) {
        if (objects == null) {
            return;
        }
        Iterator iterator = objects.values().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            Map processors = this.lookupCollection(class$org$mule$impl$registry$ObjectProcessor == null ? TransientRegistry.class$("org.mule.impl.registry.ObjectProcessor") : class$org$mule$impl$registry$ObjectProcessor);
            Iterator iterator2 = processors.values().iterator();
            while (iterator2.hasNext()) {
                ObjectProcessor op = (ObjectProcessor)iterator2.next();
                op.process(o);
            }
        }
    }

    protected Object doLookupObject(Object key, Class returntype) throws ObjectNotFoundException {
        if (key == null) {
            throw new NullPointerException("Object key cannot be null");
        }
        Map objects = (Map)this.registry.get(returntype);
        if (objects == null && (objects = (Map)this.registry.get(Object.class)) == null) {
            throw new ObjectNotFoundException(key.toString());
        }
        Object o = objects.get(key);
        if (o == null) {
            throw new ObjectNotFoundException(key.toString());
        }
        return o;
    }

    protected MuleConfiguration getLocalConfiguration() {
        return this.config;
    }

    public void setConfiguration(MuleConfiguration config) {
        this.config = config;
    }

    public Map doLookupCollection(Class returntype) {
        return (Map)this.registry.get(returntype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDescriptor lookupServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        AbstractServiceDescriptor.Key key = new AbstractServiceDescriptor.Key(name, overrides);
        ServiceDescriptor sd = (ServiceDescriptor)sdCache.get(key);
        TransientRegistry transientRegistry = this;
        synchronized (transientRegistry) {
            if (sd == null) {
                if (this.getParent() != null) {
                    sd = this.getParent().lookupServiceDescriptor(type, name, overrides);
                    sdCache.put(key, sd);
                } else {
                    sd = this.createServiceDescriptor(type, name, overrides);
                }
            }
        }
        return sd;
    }

    protected ServiceDescriptor createServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        Properties props = SpiUtils.findServiceDescriptor(type, name);
        if (props == null) {
            throw new ServiceException(CoreMessages.failedToLoad(type + " " + name));
        }
        return ServiceDescriptorFactory.create(type, name, props, overrides, null);
    }

    protected Map getObjectTypeMap(Object o) {
        Object key = o instanceof Class ? (Class)o : (o instanceof String ? o : o.getClass());
        HashMap objects = (HashMap)this.registry.get(key);
        if (objects == null) {
            objects = new HashMap(8);
            this.registry.put(key, objects);
        }
        return objects;
    }

    protected Object applyProcessors(Object object) {
        Object theObject = object;
        Map processors = this.lookupCollection(ObjectProcessor.class);
        Iterator iterator = processors.values().iterator();
        while (iterator.hasNext()) {
            ObjectProcessor o = (ObjectProcessor)iterator.next();
            theObject = o.process(theObject);
        }
        return theObject;
    }

    protected void applyLifecycle(Object object) {
        try {
            this.getManagementContext().getLifecycleManager().applyLifecycle(this.getManagementContext(), object);
        }
        catch (UMOException e) {
            throw new MuleRuntimeException(CoreMessages.failedToInvokeLifecycle(this.getManagementContext().getLifecycleManager().getCurrentPhase(), object), (Throwable)e);
        }
    }

    public void registerObject(Object key, Object value) {
        this.registerObject(Object.class, key, value);
    }

    public void registerObject(Class type, Object key, Object value) {
        if (this.isInitialised() || this.isInitialising()) {
            value = this.applyProcessors(value);
        }
        this.getObjectTypeMap(type).put(key, value);
        this.applyLifecycle(value);
    }

    public void registerAgent(UMOAgent agent) throws UMOException {
        this.registerObject(UMOAgent.class, agent.getName(), agent);
    }

    public void registerConnector(UMOConnector connector) throws UMOException {
        this.registerObject(UMOConnector.class, connector.getName(), connector);
    }

    public void registerEndpoint(UMOEndpoint endpoint) throws UMOException {
        this.registerObject(UMOImmutableEndpoint.class, endpoint.getName(), endpoint);
    }

    public void registerModel(UMOModel model) throws UMOException {
        this.registerObject(UMOModel.class, model.getName(), model);
    }

    public void registerProperties(Map props) {
        this.getObjectTypeMap("_muleProperties").putAll(props);
    }

    public void registerProperty(Object key, Object value) {
        this.getObjectTypeMap("_muleProperties").put(key, value);
    }

    public Object lookupProperty(Object key) {
        return this.getObjectTypeMap("_muleProperties").get(key);
    }

    public void registerTransformer(UMOTransformer transformer) throws UMOException {
        this.registerObject(UMOTransformer.class, transformer.getName(), transformer);
    }

    public void registerService(UMODescriptor service) throws UMOException {
        UMOModel model;
        String modelName = service.getModelName();
        if (modelName == null) {
            this.logger.warn((Object)"Model name not ser on service, using default: default");
            modelName = "default";
            service.setModelName(modelName);
        }
        if ((model = this.lookupModel(modelName)) == null) {
            throw new IllegalStateException("Service must be associated with an existing model. Not found: " + modelName);
        }
        this.registerObject(UMODescriptor.class, service.getName(), service);
        model.registerComponent(service);
    }

    public UMODescriptor unregisterService(String serviceName) {
        return (UMODescriptor)this.getObjectTypeMap(UMODescriptor.class).remove(serviceName);
    }

    public UMOAgent unregisterAgent(String agentName) throws UMOException {
        return (UMOAgent)this.getObjectTypeMap(UMOAgent.class).remove(agentName);
    }

    public UMOConnector unregisterConnector(String connectorName) throws UMOException {
        return (UMOConnector)this.getObjectTypeMap(UMOConnector.class).remove(connectorName);
    }

    public UMOImmutableEndpoint unregisterEndpoint(String endpointName) {
        return (UMOImmutableEndpoint)this.getObjectTypeMap(UMOImmutableEndpoint.class).remove(endpointName);
    }

    public UMOModel unregisterModel(String modelName) {
        return (UMOModel)this.getObjectTypeMap(UMOModel.class).remove(modelName);
    }

    public UMOTransformer unregisterTransformer(String transformerName) {
        return (UMOTransformer)this.getObjectTypeMap(UMOTransformer.class).remove(transformerName);
    }

    public UMOEndpoint lookupEndpoint(String name) {
        UMOEndpoint ep = super.lookupEndpoint(name);
        if (ep != null) {
            try {
                ep = new MuleEndpoint(ep);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ep;
    }

    public UMOTransformer lookupTransformer(String name) {
        UMOTransformer transformer = super.lookupTransformer(name);
        if (transformer != null) {
            try {
                if (transformer.getEndpoint() != null) {
                    throw new IllegalStateException("Endpoint cannot be set");
                }
                transformer = (UMOTransformer)BeanUtils.cloneBean((Object)transformer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return transformer;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isRemote() {
        return false;
    }

    public static TransientRegistry createNew() throws UMOException {
        GenericLifecycleManager lifecycleManager = new GenericLifecycleManager();
        lifecycleManager.registerLifecycle(new ContainerManagedLifecyclePhase("initialise", Initialisable.class, "dispose"));
        lifecycleManager.registerLifecycle(new ManagementContextStartPhase());
        lifecycleManager.registerLifecycle(new ManagementContextStopPhase());
        lifecycleManager.registerLifecycle(new ContainerManagedLifecyclePhase("dispose", Disposable.class, "initialise"));
        TransientRegistry registry = new TransientRegistry();
        RegistryContext.setRegistry(registry);
        MuleConfiguration config = new MuleConfiguration();
        registry.setConfiguration(config);
        TransactionalQueueManager queueManager = new TransactionalQueueManager();
        queueManager.setPersistenceStrategy(new CachingPersistenceStrategy(new MemoryPersistenceStrategy()));
        ThreadingProfile tp = config.getDefaultThreadingProfile();
        MuleWorkManager workManager = new MuleWorkManager(tp, "MuleServer");
        ServerNotificationManager notificationManager = new ServerNotificationManager();
        notificationManager.registerEventType(ManagerNotificationListener.class, ManagerNotification.class);
        notificationManager.registerEventType(ModelNotificationListener.class, ModelNotification.class);
        notificationManager.registerEventType(ComponentNotificationListener.class, ComponentNotification.class);
        notificationManager.registerEventType(SecurityNotificationListener.class, SecurityNotification.class);
        notificationManager.registerEventType(ManagementNotificationListener.class, ManagementNotification.class);
        notificationManager.registerEventType(AdminNotificationListener.class, AdminNotification.class);
        notificationManager.registerEventType(CustomNotificationListener.class, CustomNotification.class);
        notificationManager.registerEventType(ConnectionNotificationListener.class, ConnectionNotification.class);
        notificationManager.registerEventType(RegistryNotificationListener.class, RegistryNotification.class);
        notificationManager.registerEventType(ExceptionNotificationListener.class, ExceptionNotification.class);
        notificationManager.registerEventType(TransactionNotificationListener.class, TransactionNotification.class);
        MuleSecurityManager securityManager = new MuleSecurityManager();
        ManagementContext context = new ManagementContext(lifecycleManager);
        context.setId(UUID.getUUID());
        registry.registerObject(UMOManagementContext.class, "_muleManagementContext", context);
        registry.registerObject(ObjectProcessor.class, "_muleManagementContextProcessor", new ManagementContextDependencyProcessor(context));
        registry.registerObject("_muleSecurityManager", securityManager);
        registry.registerObject("_muleWorkManager", workManager);
        registry.registerObject("_muleNotificationManager", notificationManager);
        registry.registerObject("_muleQueueManager", queueManager);
        context.setWorkManager(workManager);
        context.setSecurityManager(securityManager);
        context.setNotificationManager(notificationManager);
        context.setQueueManager(queueManager);
        ModelServiceDescriptor sd = (ModelServiceDescriptor)registry.lookupServiceDescriptor("model", config.getSystemModelType(), null);
        UMOModel model = sd.createModel();
        model.setName("_muleSystemModel");
        registry.registerModel(model);
        registry.initialise();
        return registry;
    }
}

