/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.config.MuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.spring.SpringRegistry;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.internal.notifications.RegistryNotification;
import org.mule.providers.service.TransportFactory;
import org.mule.registry.DeregistrationException;
import org.mule.registry.Registration;
import org.mule.registry.RegistrationException;
import org.mule.registry.RegistryStore;
import org.mule.registry.impl.MuleRegistration;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Registerable;
import org.mule.umo.lifecycle.UMOLifecycleManager;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.registry.RegistryFacade;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.UUID;

public abstract class AbstractRegistry
implements RegistryFacade {
    private RegistryFacade parent;
    private String id;
    private int defaultScope = 2;
    private static Log logger = LogFactory.getLog((Class)SpringRegistry.class);
    protected UMOManagementContext managementContext;
    protected UMOLifecycleManager lifecycleManager;

    protected AbstractRegistry(String id) {
        if (id == null) {
            throw new NullPointerException(CoreMessages.objectIsNull("RegistryID").getMessage());
        }
        this.id = id;
        this.lifecycleManager = this.createLifecycleManager();
    }

    protected AbstractRegistry(String id, RegistryFacade parent) {
        this(id);
        this.setParent(parent);
        this.lifecycleManager = this.createLifecycleManager();
    }

    protected abstract UMOLifecycleManager createLifecycleManager();

    protected UMOLifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public final String getRegistryId() {
        return this.id;
    }

    public final synchronized void dispose() {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.doDispose();
            this.lifecycleManager.firePhase(this.getManagementContext(), "dispose");
            if (this.getParent() != null) {
                this.parent.dispose();
            } else {
                RegistryContext.setRegistry(null);
            }
        }
        catch (UMOException e) {
            logger.error((Object)("Failed to cleanly dispose: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void doDispose() {
    }

    public boolean isDisposed() {
        return this.lifecycleManager.isPhaseComplete("dispose");
    }

    public boolean isDisposing() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    public boolean isInitialised() {
        return this.lifecycleManager.isPhaseComplete("initialise");
    }

    public boolean isInitialising() {
        return "initialise".equals(this.lifecycleManager.getExecutingPhase());
    }

    public final void initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.getParent() != null) {
            this.parent.initialise();
        }
        this.fireSystemEvent(new RegistryNotification((RegistryFacade)this, 1001));
        if (this.id == null) {
            logger.warn((Object)"No unique id has been set on this registry");
            this.id = UUID.getUUID();
        }
        try {
            this.doInitialise();
            this.lifecycleManager.firePhase(this.getManagementContext(), "initialise");
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void doInitialise() throws InitialisationException {
    }

    public UMOConnector lookupConnector(String name) {
        return (UMOConnector)this.lookupObject((Object)name, UMOConnector.class);
    }

    public UMOEndpoint lookupEndpoint(String name) {
        UMOEndpoint ep = (UMOEndpoint)this.lookupObject((Object)name, UMOImmutableEndpoint.class);
        if (ep != null && ep.getType().equals("global")) {
            ep.setType("senderAndReceiver");
        }
        return ep;
    }

    public UMOTransformer lookupTransformer(String name) {
        return (UMOTransformer)this.lookupObject((Object)name, UMOTransformer.class);
    }

    public UMOModel lookupModel(String name) {
        return (UMOModel)this.lookupObject((Object)name, UMOModel.class);
    }

    public Map getModels() {
        return this.lookupCollection(UMOModel.class);
    }

    public Map getConnectors() {
        return this.lookupCollection(UMOConnector.class);
    }

    public Map getAgents() {
        return this.lookupCollection(UMOAgent.class);
    }

    public Map getEndpoints() {
        return this.lookupCollection(UMOImmutableEndpoint.class);
    }

    public Map getServices() {
        return this.lookupCollection(UMODescriptor.class);
    }

    public Map getTransformers() {
        return this.lookupCollection(UMOTransformer.class);
    }

    public UMOAgent lookupAgent(String name) {
        return (UMOAgent)this.lookupObject((Object)name, UMOAgent.class);
    }

    public UMODescriptor lookupService(String name) {
        return (UMODescriptor)this.lookupObject((Object)name, UMODescriptor.class);
    }

    protected void fireSystemEvent(UMOServerNotification e) {
        if (this.getManagementContext() != null) {
            this.getManagementContext().fireNotification(e);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Event Manager is not enabled, ignoring event: " + e));
        }
    }

    public Registration registerMuleObject(Registerable parent, Registerable object) throws RegistrationException {
        return new MuleRegistration();
    }

    public void deregisterComponent(String registryId) throws DeregistrationException {
    }

    public final Object lookupObject(Object key, int scope) {
        return this.lookupObject(key, Object.class, scope);
    }

    public final Object lookupObject(Object key, Class returntype, int scope) {
        Object o = null;
        try {
            o = this.doLookupObject(key, returntype);
            if (returntype.isAssignableFrom(o.getClass())) {
                return o;
            }
            throw new IllegalArgumentException("Object was found in registry with key: " + key + ". But object was of type: " + o.getClass().getName() + ", not of expected type: " + returntype);
        }
        catch (ObjectNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to find object in Registry ID: " + this.getRegistryId()));
            }
            if (this.getParent() != null && scope > 0) {
                if (this.getParent().isRemote() && scope == 2) {
                    o = this.getParent().lookupObject(key, returntype);
                } else if (!this.getParent().isRemote() && scope >= 1) {
                    o = this.getParent().lookupObject(key, returntype);
                }
            }
            if (o == null && key.toString().indexOf(".") > 0) {
                try {
                    o = ClassUtils.instanciateClass(key.toString(), ClassUtils.NO_ARGS, this.getClass());
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            return o;
        }
    }

    public final Map lookupCollection(Class returntype, int scope) {
        HashMap collection = this.doLookupCollection(returntype);
        if (collection == null) {
            collection = new HashMap(8);
        }
        if (this.getParent() != null && scope > 0) {
            Map collection2;
            if (this.getParent().isRemote() && scope == 2) {
                Map collection22 = this.getParent().lookupCollection(returntype);
                if (collection22 != null) {
                    collection.putAll(collection22);
                }
            } else if (!this.getParent().isRemote() && scope >= 1 && (collection2 = this.getParent().lookupCollection(returntype)) != null) {
                collection.putAll(collection2);
            }
        }
        return collection;
    }

    protected abstract Map doLookupCollection(Class var1);

    public Object lookupProperty(Object key, int scope) {
        Map props = this.lookupProperties(scope);
        if (props != null) {
            return props.get(key);
        }
        return this.lookupObject(key, Object.class, scope);
    }

    public Map lookupProperties(int scope) {
        return (Map)this.lookupObject("_muleProperties", Map.class, scope);
    }

    public Map lookupCollection(Class returntype) {
        return this.lookupCollection(returntype, this.getDefaultScope());
    }

    public Object lookupObject(Object key) {
        return this.lookupObject(key, this.getDefaultScope());
    }

    public Object lookupObject(Object key, Class returnType) {
        return this.lookupObject(key, returnType, this.getDefaultScope());
    }

    public Map lookupProperties() {
        return this.lookupProperties(this.getDefaultScope());
    }

    public Object lookupProperty(Object key) {
        return this.lookupProperty(key, this.getDefaultScope());
    }

    protected abstract Object doLookupObject(Object var1, Class var2) throws ObjectNotFoundException;

    public RegistryStore getRegistryStore() {
        return null;
    }

    public Map getRegisteredComponents(String parentId, String type) {
        return null;
    }

    public Map getRegisteredComponents(String parentId) {
        return null;
    }

    public Registration getRegisteredComponent(String id) {
        return null;
    }

    public void notifyStateChange(String id, int state) {
    }

    public void notifyPropertyChange(String id, String propertyName, Object propertyValue) {
    }

    public String getPersistenceMode() {
        return null;
    }

    public UMOManagementContext getManagementContext() {
        if (this.managementContext == null) {
            this.managementContext = (UMOManagementContext)this.lookupObject("_muleManagementContext", UMOManagementContext.class, 1);
        }
        return this.managementContext;
    }

    public RegistryFacade getParent() {
        return this.parent;
    }

    public void setParent(RegistryFacade registry) {
        this.parent = registry;
    }

    public UMOEndpoint createEndpointFromUri(String uri, String type) throws UMOException {
        return this.createEndpointFromUri(new MuleEndpointURI(uri), type);
    }

    public UMOEndpoint createEndpointFromUri(UMOEndpointURI uri, String type) throws UMOException {
        uri.initialise();
        UMOEndpoint endpoint = TransportFactory.createEndpoint(uri, type);
        this.registerEndpoint(endpoint);
        return endpoint;
    }

    public UMOEndpoint getEndpointFromName(String name) throws ObjectNotFoundException {
        if (null != name) {
            return this.lookupEndpoint(name);
        }
        return null;
    }

    public UMOEndpoint getEndpointFromUri(String name) throws ObjectNotFoundException {
        return this.getEndpointFromName(name);
    }

    public UMOEndpoint getEndpointFromUri(UMOEndpointURI uri) throws UMOException {
        String address;
        String name = uri.getEndpointName();
        UMOEndpoint endpoint = this.getEndpointFromName(name);
        if (null == endpoint && null != (address = uri.getAddress())) {
            Map endpoints = this.getEndpoints();
            if (null != name && endpoints.containsKey(name)) {
                throw new IllegalStateException("Endpoint present, but direct lookup failed");
            }
            Iterator keys = endpoints.keySet().iterator();
            while (keys.hasNext()) {
                UMOEndpoint candidate;
                String candidateAddress;
                Object key = keys.next();
                Object value = endpoints.get(key);
                if (!(value instanceof UMOEndpoint) || null == (candidateAddress = (candidate = (UMOEndpoint)value).getEndpointURI().getAddress()) || !address.equals(candidateAddress)) continue;
                if (null == endpoint) {
                    endpoint = candidate;
                    continue;
                }
                throw new IllegalStateException("Duplicate endpoint URI");
            }
        }
        return endpoint;
    }

    public UMOEndpoint getOrCreateEndpointForUri(String uriIdentifier, String type) throws UMOException {
        UMOEndpoint endpoint = this.getEndpointFromName(uriIdentifier);
        if (endpoint == null) {
            endpoint = this.createEndpointFromUri(new MuleEndpointURI(uriIdentifier), type);
        } else if (!endpoint.getType().equals(type) && !endpoint.getType().equals("senderAndReceiver")) {
            throw new IllegalArgumentException("Endpoint matching: " + uriIdentifier + " is not of type: " + type + ". It is of type: " + endpoint.getType());
        }
        return endpoint;
    }

    public UMOEndpoint getOrCreateEndpointForUri(UMOEndpointURI uri, String type) throws UMOException {
        UMOEndpoint endpoint = this.getEndpointFromUri(uri);
        if (endpoint == null) {
            endpoint = this.createEndpointFromUri(uri, type);
        }
        return endpoint;
    }

    protected void unsupportedOperation(String operation, Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Registry: " + this.getRegistryId() + " is read-only so objects cannot be registered or unregistered. Failed to execute operation " + operation + " on object: " + o);
    }

    public void registerConnector(UMOConnector connector) throws UMOException {
        this.unsupportedOperation("registerConnector", connector);
    }

    public UMOConnector unregisterConnector(String connectorName) throws UMOException {
        this.unsupportedOperation("unregisterConnector", connectorName);
        return null;
    }

    public void registerEndpoint(UMOEndpoint lookup) throws UMOException {
        this.unsupportedOperation("registerEndpoint", lookup);
    }

    public UMOImmutableEndpoint unregisterEndpoint(String endpointName) {
        this.unsupportedOperation("unregisterEndpoint", endpointName);
        return null;
    }

    public void registerTransformer(UMOTransformer transformer) throws UMOException {
        this.unsupportedOperation("registerTransformer", transformer);
    }

    public UMOTransformer unregisterTransformer(String transformerName) {
        this.unsupportedOperation("unregistertransformer", transformerName);
        return null;
    }

    public void registerService(UMODescriptor service) throws UMOException {
        this.unsupportedOperation("registerService", service);
    }

    public UMODescriptor unregisterService(String serviceName) {
        this.unsupportedOperation("unregisterService", serviceName);
        return null;
    }

    public void registerModel(UMOModel model) throws UMOException {
        this.unsupportedOperation("registerModel", model);
    }

    public UMOModel unregisterModel(String modelName) {
        this.unsupportedOperation("unregisterModel", modelName);
        return null;
    }

    public void registerAgent(UMOAgent agent) throws UMOException {
        this.unsupportedOperation("registerAgent", agent);
    }

    public UMOAgent unregisterAgent(String agentName) throws UMOException {
        this.unsupportedOperation("unregisterAgent", agentName);
        return null;
    }

    public void registerProperty(Object key, Object value) {
        this.unsupportedOperation("registerProperty", value);
    }

    public void registerProperties(Map props) {
        this.unsupportedOperation("registerProperties", props);
    }

    public void registerObject(Object key, Object value) {
        this.unsupportedOperation("registerObject", value);
    }

    public Object unregisterObject(String key) {
        this.unsupportedOperation("unregisterObject", key);
        return null;
    }

    public final MuleConfiguration getConfiguration() {
        MuleConfiguration config = this.getLocalConfiguration();
        if (config == null && this.getParent() != null) {
            config = this.getParent().getConfiguration();
        }
        if (config == null) {
            config = new MuleConfiguration();
            this.setConfiguration(config);
        }
        return config;
    }

    public int getDefaultScope() {
        return this.defaultScope;
    }

    public void setDefaultScope(int scope) {
        if (scope < 0 || scope > 2) {
            throw new IllegalArgumentException("Invalid value for scope: " + scope);
        }
        this.defaultScope = scope;
    }

    protected abstract MuleConfiguration getLocalConfiguration();
}

