/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.pipeline;

import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.model.ComponentFactory;
import org.mule.impl.model.direct.DirectComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.DispatchException;

public class PipelineComponent
extends DirectComponent {
    private static final long serialVersionUID = -2788210157354765190L;
    private Callable callable;

    public PipelineComponent(MuleDescriptor descriptor, UMOModel model) {
        super(descriptor, model);
    }

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        Object component = null;
        try {
            component = ComponentFactory.createService(this.getDescriptor());
        }
        catch (UMOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (!(component instanceof Callable)) {
            throw new InitialisationException(CoreMessages.objectNotOfCorrectType(component.getClass(), Callable.class), (Initialisable)this);
        }
        this.callable = (Callable)component;
        if (component instanceof Initialisable) {
            ((Initialisable)component).initialise();
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws UMOException {
        try {
            Object result = this.callable.onCall(RequestContext.getEventContext());
            UMOMessage returnMessage = null;
            returnMessage = result instanceof UMOMessage ? (UMOMessage)result : new MuleMessage(result, event.getMessage());
            if (!event.isStopFurtherProcessing()) {
                if (this.descriptor.getOutboundRouter().hasEndpoints()) {
                    UMOMessage outboundReturnMessage = this.descriptor.getOutboundRouter().route(returnMessage, event.getSession(), event.isSynchronous());
                    if (outboundReturnMessage != null) {
                        returnMessage = outboundReturnMessage;
                    }
                } else {
                    this.logger.debug((Object)("Outbound router on component '" + this.descriptor.getName() + "' doesn't have any endpoints configured."));
                }
            }
            return returnMessage;
        }
        catch (Exception e) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    protected void doDispatch(UMOEvent event) throws UMOException {
        this.sendEvent(event);
    }

    protected void doDispose() {
        if (this.callable instanceof Disposable) {
            ((Disposable)((Object)this.callable)).dispose();
        }
    }
}

