/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.impl.DefaultComponentExceptionStrategy;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.RequestContext;
import org.mule.impl.internal.notifications.ComponentNotification;
import org.mule.impl.model.ComponentFactory;
import org.mule.management.stats.ComponentStatistics;
import org.mule.providers.AbstractConnector;
import org.mule.registry.DeregistrationException;
import org.mule.registry.RegistrationException;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.model.ModelException;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.concurrent.WaitableBoolean;

public abstract class AbstractComponent
implements UMOComponent {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleDescriptor descriptor = null;
    protected ComponentStatistics stats = null;
    protected AtomicBoolean stopped = new AtomicBoolean(true);
    protected WaitableBoolean stopping = new WaitableBoolean(false);
    protected AtomicBoolean poolInitialised = new AtomicBoolean(false);
    protected ExceptionListener exceptionListener = null;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected UMOModel model;
    protected WaitableBoolean paused = new WaitableBoolean(false);
    protected String registryId = null;

    public AbstractComponent(MuleDescriptor descriptor, UMOModel model) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        this.descriptor = descriptor;
        this.model = model;
    }

    protected UMOManagementContext getManagementContext() {
        return this.model.getManagementContext();
    }

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new InitialisationException(CoreMessages.objectAlreadyInitialised("Component '" + this.descriptor.getName() + "'"), (Initialisable)this);
        }
        try {
            this.register();
        }
        catch (RegistrationException re) {
            this.logger.info((Object)"Unable to register component");
        }
        try {
            this.descriptor.register();
        }
        catch (UMOException e) {
            this.logger.error((Object)("Unable to register descriptor " + this.descriptor.getName() + " with the registry"));
        }
        this.exceptionListener = this.descriptor.getExceptionListener();
        this.doInitialise();
        this.stats = this.createStatistics();
        this.stats.setEnabled(this.getManagementContext().getStatistics().isEnabled());
        this.getManagementContext().getStatistics().add(this.stats);
        this.stats.setOutboundRouterStat(this.getDescriptor().getOutboundRouter().getStatistics());
        this.stats.setInboundRouterStat(this.getDescriptor().getInboundRouter().getStatistics());
        this.initialised.set(true);
        this.fireComponentNotification(301);
    }

    protected ComponentStatistics createStatistics() {
        return new ComponentStatistics(this.getName(), this.descriptor.getThreadingProfile().getMaxThreadsActive());
    }

    public void register() throws RegistrationException {
        this.registryId = this.getManagementContext().getRegistry().registerMuleObject(this.model, this).getId();
    }

    public void deregister() throws DeregistrationException {
        this.getManagementContext().getRegistry().deregisterComponent(this.registryId);
        this.registryId = null;
    }

    public String getRegistryId() {
        return this.registryId;
    }

    protected void fireComponentNotification(int action) {
        this.getManagementContext().fireNotification(new ComponentNotification(this.descriptor, action));
    }

    public void forceStop() throws UMOException {
        if (!this.stopped.get()) {
            this.logger.debug((Object)"Stopping UMOComponent");
            this.stopping.set(true);
            this.fireComponentNotification(307);
            this.doForceStop();
            this.stopped.set(true);
            this.stopping.set(false);
            this.fireComponentNotification(303);
        }
    }

    public void stop() throws UMOException {
        if (!this.stopped.get()) {
            this.logger.debug((Object)"Stopping UMOComponent");
            this.stopping.set(true);
            this.fireComponentNotification(307);
            this.unregisterListeners();
            if (this.getManagementContext().getQueueManager().getQueueSession().getQueue(this.descriptor.getName() + ".component").size() > 0) {
                try {
                    this.stopping.whenFalse(null);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doStop();
            this.stopped.set(true);
            this.initialised.set(false);
            this.fireComponentNotification(303);
        }
    }

    public void start() throws UMOException {
        this.start(false);
    }

    void start(boolean startPaused) throws UMOException {
        this.registerListeners();
        this.connectListeners();
        if (this.stopped.get()) {
            this.stopped.set(false);
            this.paused.set(false);
            this.doStart();
        }
        this.fireComponentNotification(302);
        if (startPaused) {
            this.pause();
        }
        this.startListeners();
    }

    public final void pause() throws UMOException {
        this.doPause();
        this.paused.set(true);
        this.fireComponentNotification(304);
    }

    public final void resume() throws UMOException {
        this.doResume();
        this.paused.set(false);
        this.fireComponentNotification(305);
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    protected void doPause() throws UMOException {
    }

    protected void doResume() throws UMOException {
    }

    public final void dispose() {
        try {
            if (!this.stopped.get()) {
                this.stop();
            }
        }
        catch (UMOException e) {
            this.logger.error((Object)("Failed to stop component: " + this.descriptor.getName()), (Throwable)e);
        }
        this.doDispose();
        this.fireComponentNotification(306);
        this.getManagementContext().getStatistics().remove(this.stats);
    }

    public ComponentStatistics getStatistics() {
        return this.stats;
    }

    public UMODescriptor getDescriptor() {
        return this.descriptor;
    }

    public void dispatchEvent(UMOEvent event) throws UMOException {
        if (this.stopping.get() || this.stopped.get()) {
            throw new ComponentException(CoreMessages.componentIsStopped(this.getDescriptor().getName()), event.getMessage(), this);
        }
        try {
            this.waitIfPaused(event);
        }
        catch (InterruptedException e) {
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
        UMOImmutableEndpoint endpoint = event.getEndpoint();
        if (!endpoint.canReceive()) {
            try {
                endpoint.dispatch(event);
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
            return;
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Component: " + this.descriptor.getName() + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        this.doDispatch(event);
    }

    public UMOMessage sendEvent(UMOEvent event) throws UMOException {
        if (this.stopping.get() || this.stopped.get()) {
            throw new ComponentException(CoreMessages.componentIsStopped(this.getDescriptor().getName()), event.getMessage(), this);
        }
        try {
            this.waitIfPaused(event);
        }
        catch (InterruptedException e) {
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventSync();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Component: " + this.descriptor.getName() + " has received synchronous event on: " + event.getEndpoint().getEndpointURI()));
        }
        RequestContext.setEvent(event);
        return this.doSend(event);
    }

    protected void waitIfPaused(UMOEvent event) throws InterruptedException {
        if (this.logger.isDebugEnabled() && this.paused.get()) {
            this.logger.debug((Object)("Component: " + this.descriptor.getName() + " is paused. Blocking call until resume is called"));
        }
        this.paused.whenFalse(null);
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String toString() {
        return this.descriptor.getName();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    protected void handleException(Exception e) {
        if (this.exceptionListener instanceof DefaultComponentExceptionStrategy && ((DefaultComponentExceptionStrategy)this.exceptionListener).getComponent() == null) {
            ((DefaultComponentExceptionStrategy)this.exceptionListener).setComponent(this);
        }
        this.exceptionListener.exceptionThrown(e);
    }

    protected void doForceStop() throws UMOException {
    }

    protected void doStop() throws UMOException {
    }

    protected void doStart() throws UMOException {
    }

    protected void doDispose() {
    }

    protected void doInitialise() throws InitialisationException {
    }

    public boolean isStarted() {
        return !this.stopped.get();
    }

    protected abstract UMOMessage doSend(UMOEvent var1) throws UMOException;

    protected abstract void doDispatch(UMOEvent var1) throws UMOException;

    public Object getInstance() throws UMOException {
        return ComponentFactory.createService(this.getDescriptor());
    }

    protected void registerListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            try {
                endpoint.getConnector().registerListener(this, endpoint);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedtoRegisterOnEndpoint(this.getDescriptor().getName(), endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    protected void unregisterListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            try {
                endpoint.getConnector().unregisterListener(this, endpoint);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ModelException(CoreMessages.failedToUnregister(this.getDescriptor().getName(), endpoint.getEndpointURI()), (Throwable)e);
            }
        }
    }

    protected void startListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            UMOMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null || !endpoint.getConnector().isStarted() || !endpoint.getInitialState().equals("started")) continue;
            receiver.start();
        }
    }

    protected void stopListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            UMOMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            receiver.stop();
        }
    }

    protected void connectListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            UMOMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            try {
                receiver.connect();
            }
            catch (Exception e) {
                throw new ModelException(MessageFactory.createStaticMessage("Failed to connect listener " + receiver + " for endpoint " + endpoint.getName()), (Throwable)e);
            }
        }
    }

    protected void disconnectListeners() throws UMOException {
        List endpoints = this.getIncomingEndpoints();
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            UMOMessageReceiver receiver = ((AbstractConnector)endpoint.getConnector()).getReceiver(this, endpoint);
            if (receiver == null) continue;
            try {
                receiver.disconnect();
            }
            catch (Exception e) {
                throw new ModelException(MessageFactory.createStaticMessage("Failed to disconnect listener " + receiver + " for endpoint " + endpoint.getName()), (Throwable)e);
            }
        }
    }

    protected List getIncomingEndpoints() {
        ArrayList endpoints = new ArrayList();
        endpoints.addAll(this.getDescriptor().getInboundRouter().getEndpoints());
        if (this.getDescriptor().getResponseRouter() != null && this.getDescriptor().getResponseRouter().getEndpoints() != null) {
            endpoints.addAll(this.getDescriptor().getResponseRouter().getEndpoints());
        }
        return endpoints;
    }
}

