/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingDeque;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.ManagementContextAware;
import org.mule.impl.internal.notifications.BlockingServerEvent;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.routing.filters.WildcardFilter;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.util.ClassUtils;
import org.mule.util.concurrent.ConcurrentHashSet;

public class ServerNotificationManager
implements Work,
Disposable,
ManagementContextAware {
    protected static final Log logger = LogFactory.getLog((Class)ServerNotificationManager.class);
    public static final String NULL_SUBSCRIPTION = "NULL";
    private ConcurrentMap eventsMap = new ConcurrentHashMap();
    private BlockingDeque eventQueue = new LinkedBlockingDeque();
    private Set listeners = new ConcurrentHashSet();
    private WorkListener workListener;
    private volatile boolean disposed = false;
    private UMOManagementContext managementContext;

    public void setManagementContext(UMOManagementContext context) {
        this.managementContext = context;
        this.workListener = RegistryContext.getConfiguration().getDefaultWorkListener();
    }

    public void start(UMOWorkManager workManager) throws LifecycleException {
        try {
            workManager.scheduleWork(this, Long.MAX_VALUE, null, this.workListener);
        }
        catch (WorkException e) {
            throw new LifecycleException(e, (Object)this);
        }
    }

    public void setEventTypes(Map eventTypes) throws ClassNotFoundException {
        this.eventsMap = new ConcurrentHashMap(eventTypes.size());
        Iterator iterator = eventTypes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.registerEventType(this.getClassFromValue(entry.getKey()), this.getClassFromValue(entry.getValue()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private Class getClassFromValue(Object value) throws ClassNotFoundException {
        void var2_2;
        Class theClass;
        if (value instanceof String) {
            theClass = ClassUtils.loadClass(value.toString(), this.getClass());
        } else if (value instanceof Class) {
            theClass = (Class)value;
        } else {
            throw new IllegalArgumentException("Notification types and listeners must be a Class of fully qualified class name. Value is: " + value);
        }
        return var2_2;
    }

    public Map getEventTypes() {
        return Collections.unmodifiableMap(this.eventsMap);
    }

    public void registerEventType(Class listenerType, Class eventType) {
        if (UMOServerNotification.class.isAssignableFrom(eventType)) {
            Class previousEventType = (Class)this.eventsMap.putIfAbsent((Object)listenerType, (Object)eventType);
            if (previousEventType != null) {
                eventType = previousEventType;
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registered event type: " + eventType));
                logger.debug((Object)("Binding listener type '" + listenerType + "' to event type '" + eventType + "'"));
            }
        } else {
            throw new IllegalArgumentException(CoreMessages.propertyIsNotSupportedType("eventType", UMOServerNotification.class, eventType).getMessage());
        }
    }

    public void registerListener(UMOServerNotificationListener listener) throws NotificationException {
        this.registerListener(listener, null);
    }

    public void registerListener(UMOServerNotificationListener listener, String subscription) throws NotificationException {
        this.listeners.add(new Listener(listener, subscription));
    }

    public void unregisterListener(UMOServerNotificationListener listener) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener l = (Listener)iterator.next();
            if (!l.getListenerObject().equals(listener)) continue;
            this.listeners.remove(l);
            break;
        }
    }

    public void fireEvent(UMOServerNotification notification) {
        block5: {
            if (this.disposed) {
                return;
            }
            if (notification instanceof BlockingServerEvent) {
                this.notifyListeners(notification);
            } else {
                try {
                    this.eventQueue.put((Object)notification);
                }
                catch (InterruptedException e) {
                    if (this.disposed) break block5;
                    logger.error((Object)("Failed to queue notification: " + notification), (Throwable)e);
                }
            }
        }
    }

    public void dispose() {
        this.disposed = true;
        this.eventsMap.clear();
        this.eventQueue.clear();
        this.listeners.clear();
        this.workListener = null;
    }

    protected void notifyListeners(UMOServerNotification notification) {
        if (this.disposed) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            if (!listener.matches(notification)) continue;
            listener.getListenerObject().onNotification(notification);
        }
    }

    public void release() {
        this.dispose();
    }

    public void run() {
        while (!this.disposed) {
            try {
                UMOServerNotification notification = (UMOServerNotification)this.eventQueue.take();
                if (notification == null) continue;
                this.notifyListeners(notification);
            }
            catch (InterruptedException e) {
                if (this.disposed) continue;
                logger.error((Object)"Failed to take notification from queue", (Throwable)e);
            }
        }
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public void setWorkListener(WorkListener workListener) {
        if (workListener == null) {
            throw new IllegalArgumentException("workListener may not be null");
        }
        this.workListener = workListener;
    }

    protected class Listener {
        private final UMOServerNotificationListener listener;
        private final List notificationClasses;
        private final String subscription;
        private final WildcardFilter subscriptionFilter;

        public Listener(UMOServerNotificationListener listener, String subscription) {
            this.listener = listener;
            this.subscription = subscription == null ? ServerNotificationManager.NULL_SUBSCRIPTION : subscription;
            this.subscriptionFilter = new WildcardFilter(this.subscription);
            this.subscriptionFilter.setCaseSensitive(false);
            this.notificationClasses = new ArrayList();
            Iterator iterator = ServerNotificationManager.this.eventsMap.keySet().iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                if (!clazz.isAssignableFrom(listener.getClass())) continue;
                this.notificationClasses.add(ServerNotificationManager.this.eventsMap.get((Object)clazz));
            }
        }

        public UMOServerNotificationListener getListenerObject() {
            return this.listener;
        }

        public List getNotificationClasses() {
            return this.notificationClasses;
        }

        public String getSubscription() {
            return this.subscription;
        }

        public boolean matches(UMOServerNotification notification) {
            if (this.subscriptionMatches(notification)) {
                Iterator iterator = this.notificationClasses.iterator();
                while (iterator.hasNext()) {
                    Class notificationClass = (Class)iterator.next();
                    if (!notificationClass.isAssignableFrom(notification.getClass())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean subscriptionMatches(UMOServerNotification notification) {
            String resourceId = notification.getResourceIdentifier();
            return ServerNotificationManager.NULL_SUBSCRIPTION.equals(this.subscription) || this.subscriptionFilter.accept(resourceId);
        }
    }
}

