/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.notifications;

import org.mule.impl.internal.notifications.BlockingServerEvent;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.manager.UMOServerNotification;

public class ManagerNotification
extends UMOServerNotification
implements BlockingServerEvent {
    private static final long serialVersionUID = -3246036188011581121L;
    public static final int MANAGER_INITIALISING = 101;
    public static final int MANAGER_INITIALISED = 102;
    public static final int MANAGER_STARTING = 103;
    public static final int MANAGER_STARTED = 104;
    public static final int MANAGER_STOPPING = 105;
    public static final int MANAGER_STOPPED = 106;
    public static final int MANAGER_DISPOSING = 107;
    public static final int MANAGER_DISPOSED = 108;
    public static final int MANAGER_DISPOSING_CONNECTORS = 109;
    public static final int MANAGER_DISPOSED_CONNECTORS = 110;
    public static final int MANAGER_STARTING_MODELS = 111;
    public static final int MANAGER_STARTED_MODELS = 112;
    public static final int MANAGER_STOPPING_MODELS = 113;
    public static final int MANAGER_STOPPED_MODELS = 114;
    private String clusterId;
    private String domain;

    public ManagerNotification(UMOManagementContext context, String action) {
        this(context, ManagerNotification.getActionId(action));
    }

    public ManagerNotification(UMOManagementContext context, int action) {
        super(ManagerNotification.getId(context), action);
        this.resourceIdentifier = ManagerNotification.getId(context);
        this.clusterId = context.getClusterId();
        this.domain = context.getDomain();
    }

    private static String getId(UMOManagementContext context) {
        return context.getDomain() + "." + context.getClusterId() + "." + context.getId();
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getDomain() {
        return this.domain;
    }

    protected String getPayloadToString() {
        return ((UMOManagementContext)this.source).getId();
    }

    public String toString() {
        return this.EVENT_NAME + "{" + "action=" + ManagerNotification.getActionName(this.action) + ", resourceId=" + this.resourceIdentifier + ", timestamp=" + this.timestamp + "}";
    }

    static {
        ManagerNotification.registerAction("initialising", 101);
        ManagerNotification.registerAction("initialised", 102);
        ManagerNotification.registerAction("starting", 103);
        ManagerNotification.registerAction("started", 104);
        ManagerNotification.registerAction("stopping", 105);
        ManagerNotification.registerAction("stopped", 106);
        ManagerNotification.registerAction("disposing", 107);
        ManagerNotification.registerAction("disposed", 108);
        ManagerNotification.registerAction("disposing connectors", 109);
        ManagerNotification.registerAction("disposed connectors", 110);
        ManagerNotification.registerAction("starting models", 111);
        ManagerNotification.registerAction("started models", 112);
        ManagerNotification.registerAction("stopping models", 113);
        ManagerNotification.registerAction("stopped models", 114);
    }
}

