/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.impl.AbstractAgent;
import org.mule.impl.AlreadyInitialisedException;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.internal.admin.MuleManagerComponent;
import org.mule.impl.model.ModelHelper;
import org.mule.providers.service.TransportFactory;
import org.mule.transformers.wire.SerializationWireFormat;
import org.mule.transformers.wire.WireFormat;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.StringUtils;

public class MuleAdminAgent
extends AbstractAgent {
    public static final String DEFAULT_MANAGER_ENDPOINT = "_muleManagerEndpoint";
    public static final String AGENT_NAME = "Mule Admin";
    protected static final Log logger = LogFactory.getLog((Class)MuleAdminAgent.class);
    private WireFormat wireFormat;
    private String serverUri;

    public MuleAdminAgent() {
        super(AGENT_NAME);
    }

    public String getDescription() {
        return this.getName() + ": accepting connections on " + this.serverUri;
    }

    public void start() throws UMOException {
    }

    public void stop() throws UMOException {
    }

    public void dispose() {
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void initialise() throws InitialisationException {
        if (this.wireFormat == null) {
            this.wireFormat = new SerializationWireFormat();
        }
        try {
            if (StringUtils.isEmpty((String)this.serverUri)) {
                logger.warn((Object)"No serverUriUrl specified, MuleAdminAgent will not start. E.g. use <mule:admin-agent serverUri=\"tcp://example.com:60504\"/> ");
                this.managementContext.getRegistry().unregisterAgent(this.getName());
                return;
            }
            if (ModelHelper.isComponentRegistered("_muleManagerComponent")) {
                logger.info((Object)"Mule manager component has already been initialised, ignoring server url");
            } else {
                MuleEndpoint writableEndpoint;
                if (this.managementContext.getRegistry().lookupConnector(DEFAULT_MANAGER_ENDPOINT) != null) {
                    throw new AlreadyInitialisedException("Server Components", (Initialisable)this);
                }
                UMOEndpoint endpoint = this.managementContext.getRegistry().lookupEndpoint(this.serverUri);
                if (endpoint == null) {
                    MuleEndpointURI endpointUri = new MuleEndpointURI(this.serverUri);
                    UMOConnector connector = TransportFactory.getOrCreateConnectorByProtocol(endpointUri);
                    if (this.managementContext.getRegistry().lookupConnector(connector.getName()) == null) {
                        connector.setName(DEFAULT_MANAGER_ENDPOINT);
                        connector.initialise();
                        this.managementContext.getRegistry().registerConnector(connector);
                    }
                    writableEndpoint = new MuleEndpoint();
                    writableEndpoint.setConnector(connector);
                    writableEndpoint.setEndpointURI(endpointUri);
                } else {
                    writableEndpoint = new MuleEndpoint(endpoint);
                }
                logger.info((Object)("Registering Admin listener on: " + this.serverUri));
                UMODescriptor descriptor = MuleManagerComponent.getDescriptor(writableEndpoint, this.wireFormat, RegistryContext.getConfiguration().getDefaultEncoding(), RegistryContext.getConfiguration().getDefaultSynchronousEventTimeout());
                ModelHelper.registerSystemComponent(descriptor);
            }
        }
        catch (UMOException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public String toString() {
        return "MuleAdminAgent{serverUri='" + this.serverUri + "'" + "}";
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public void setServerUri(String serverUri) {
        this.serverUri = serverUri;
    }
}

