/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import java.util.Map;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.NullSessionHandler;
import org.mule.impl.internal.admin.AbstractNotificationLoggerAgent;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerNotification;

public class EndpointNotificationLoggerAgent
extends AbstractNotificationLoggerAgent {
    private String endpointAddress;
    private UMOImmutableEndpoint logEndpoint = null;
    private UMOSession session;

    public EndpointNotificationLoggerAgent() {
        super("Endpoint Logger Agent");
    }

    protected void doInitialise() throws InitialisationException {
        try {
            if (this.endpointAddress == null) {
                throw new InitialisationException(CoreMessages.propertiesNotSet("endpointAddress"), (Initialisable)this);
            }
            this.logEndpoint = this.managementContext.getRegistry().getOrCreateEndpointForUri(this.endpointAddress, "sender");
            this.session = new MuleSession(new MuleMessage((Object)NullPayload.getInstance(), (Map)null), new NullSessionHandler());
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void logEvent(UMOServerNotification e) {
        if (this.logEndpoint != null) {
            try {
                MuleMessage msg = new MuleMessage((Object)e.toString(), (Map)null);
                MuleEvent event = new MuleEvent((UMOMessage)msg, this.logEndpoint, this.session, false);
                this.logEndpoint.dispatch(event);
            }
            catch (Exception e1) {
                this.logger.error((Object)("Failed to dispatch event: " + e.toString() + " over endpoint: " + this.logEndpoint + ". Error is: " + e1.getMessage()), (Throwable)e1);
            }
        }
    }

    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append(": ");
        if (this.endpointAddress != null) {
            buf.append("Forwarding notifications to: " + this.endpointAddress);
        }
        return buf.toString();
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }
}

