/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.mule.RegistryContext;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.registry.RegistryFacade;
import org.mule.util.StringMessageUtils;

public class MuleShutdownHook
extends Thread {
    private Log logger;
    private Throwable exception = null;

    public MuleShutdownHook(Log logger) {
        this.logger = logger;
    }

    public MuleShutdownHook(Log logger, Throwable exception) {
        this(logger);
        this.exception = exception;
    }

    public void run() {
        if (this.exception != null) {
            this.shutdown(this.exception);
        } else {
            this.shutdown();
        }
    }

    protected void shutdown(Throwable t) {
        UMOManagementContext context;
        Message msg = CoreMessages.fatalErrorWhileRunning();
        UMOException muleException = ExceptionHelper.getRootMuleException(t);
        if (muleException != null) {
            this.logger.fatal((Object)muleException.getDetailedMessage());
        } else {
            this.logger.fatal((Object)(msg.toString() + " " + t.getMessage()), t);
        }
        ArrayList<Object> msgs = new ArrayList<Object>();
        msgs.add(msg.getMessage());
        Throwable root = ExceptionHelper.getRootException(t);
        msgs.add(root.getMessage() + " (" + root.getClass().getName() + ")");
        msgs.add(" ");
        msgs.add(CoreMessages.fatalErrorInShutdown());
        if (RegistryContext.getRegistry() != null && (context = RegistryContext.getRegistry().getManagementContext()) != null) {
            msgs.add(CoreMessages.serverStartedAt(context.getStartDate()));
        }
        msgs.add(CoreMessages.serverShutdownAt(new Date()));
        String shutdownMessage = StringMessageUtils.getBoilerPlate(msgs, '*', 86);
        if (this.logger.isFatalEnabled()) {
            this.logger.fatal((Object)shutdownMessage);
        } else {
            System.err.println(shutdownMessage);
        }
    }

    protected void shutdown() {
        this.logger.info((Object)"Mule server shutting down due to normal shutdown request");
        ArrayList<Message> msgs = new ArrayList<Message>();
        msgs.add(CoreMessages.normalShutdown());
        UMOManagementContext context = null;
        RegistryFacade registry = RegistryContext.getRegistry();
        if (registry != null) {
            context = registry.getManagementContext();
        }
        if (context != null) {
            msgs.add(CoreMessages.serverStartedAt(context.getStartDate()));
        }
        msgs.add(CoreMessages.serverShutdownAt(new Date()));
        String shutdownMessage = StringMessageUtils.getBoilerPlate(msgs, '*', 86);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)shutdownMessage);
        } else {
            System.out.println(shutdownMessage);
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass().getName().equals(o.getClass().getName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

