/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicReference;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.RegistryContext;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleTransactionConfig;
import org.mule.impl.UninitialisedTransformer;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ConnectionStrategy;
import org.mule.providers.SingleAttemptConnectionStrategy;
import org.mule.providers.service.TransportFactory;
import org.mule.providers.service.TransportFactoryException;
import org.mule.registry.DeregistrationException;
import org.mule.registry.RegistrationException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.MuleObjectHelper;
import org.mule.util.ObjectNameHelper;

public class ImmutableMuleEndpoint
implements UMOImmutableEndpoint {
    private static final long serialVersionUID = -2431378111247771909L;
    protected static final Log logger = LogFactory.getLog((Class)ImmutableMuleEndpoint.class);
    protected UMOConnector connector = null;
    protected UMOEndpointURI endpointUri = null;
    protected AtomicReference transformer = new AtomicReference((Object)UninitialisedTransformer.getInstance());
    protected UMOTransformer responseTransformer = null;
    protected String name = null;
    protected String type = "senderAndReceiver";
    protected Map properties = null;
    protected UMOTransactionConfig transactionConfig = null;
    protected UMOFilter filter = null;
    protected boolean deleteUnacceptedMessages = false;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected UMOEndpointSecurityFilter securityFilter = null;
    protected Boolean synchronous = null;
    protected Boolean remoteSync = null;
    protected Integer remoteSyncTimeout = null;
    protected boolean streaming = false;
    protected String initialState = "started";
    protected String endpointEncoding;
    protected int createConnector = 0;
    protected String registryId = null;
    protected UMOManagementContext managementContext;
    protected ConnectionStrategy connectionStrategy;

    private ImmutableMuleEndpoint() {
    }

    public ImmutableMuleEndpoint(String name, UMOEndpointURI endpointUri, UMOConnector connector, UMOTransformer transformer, String type, int createConnector, String endpointEncoding, Map props) {
        this.name = name;
        this.connector = connector;
        this.createConnector = createConnector;
        this.endpointEncoding = endpointEncoding;
        this.type = type;
        if (endpointUri != null) {
            this.endpointUri = new MuleEndpointURI(endpointUri);
        }
        this.initTransformerIfNotNull(transformer);
        this.properties = new ConcurrentHashMap();
        if (props != null) {
            this.properties.putAll(props);
        }
        if (endpointUri != null) {
            this.properties.putAll(endpointUri.getParams());
        }
        if (!(this instanceof MuleEndpoint)) {
            this.properties = Collections.unmodifiableMap(this.properties);
        }
        this.transactionConfig = new MuleTransactionConfig();
    }

    public ImmutableMuleEndpoint(UMOImmutableEndpoint source) throws UMOException {
        this();
        this.initFromDescriptor(source);
    }

    public ImmutableMuleEndpoint(String endpointName, boolean receiver) throws UMOException {
        this();
        String type = receiver ? "receiver" : "sender";
        UMOEndpoint p = RegistryContext.getRegistry().getOrCreateEndpointForUri(new MuleEndpointURI(endpointName), type);
        this.initFromDescriptor(p);
    }

    protected void initFromDescriptor(UMOImmutableEndpoint source) throws UMOException {
        if (this.name == null) {
            this.name = source.getName();
        }
        if (this.endpointUri == null && source.getEndpointURI() != null) {
            this.endpointUri = new MuleEndpointURI(source.getEndpointURI());
        }
        if (this.endpointEncoding == null) {
            this.endpointEncoding = source.getEncoding();
        }
        if (this.connector == null) {
            this.connector = source.getConnector();
        }
        this.initTransformerIfNotNull(source.getTransformer());
        if (this.responseTransformer == null) {
            this.responseTransformer = source.getResponseTransformer();
        }
        if (this.responseTransformer != null) {
            this.responseTransformer.setEndpoint(this);
        }
        this.properties = new ConcurrentHashMap();
        if (source.getProperties() != null) {
            this.properties.putAll(source.getProperties());
        }
        if (this.endpointUri != null && this.endpointUri.getParams() != null) {
            this.properties.putAll(this.endpointUri.getParams());
        }
        this.type = source.getType();
        this.transactionConfig = source.getTransactionConfig();
        this.deleteUnacceptedMessages = source.isDeleteUnacceptedMessages();
        this.initialState = source.getInitialState();
        this.remoteSyncTimeout = new Integer(source.getRemoteSyncTimeout());
        this.remoteSync = source.isRemoteSync();
        this.filter = source.getFilter();
        this.securityFilter = source.getSecurityFilter();
        if (this.connectionStrategy == null) {
            this.connectionStrategy = source.getConnectionStrategy();
        }
        if (source.getManagementContext() != null) {
            this.initialise();
        }
    }

    public UMOEndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    public String getEncoding() {
        return this.endpointEncoding;
    }

    public String getType() {
        return this.type;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public String getName() {
        return this.name;
    }

    public UMOTransformer getTransformer() {
        this.lazyInitTransformer();
        return this.getTransformerValue();
    }

    protected UMOTransformer getTransformerValue() {
        UMOTransformer value = (UMOTransformer)this.transformer.get();
        if (UninitialisedTransformer.getInstance() == value) {
            return null;
        }
        return value;
    }

    public Map getProperties() {
        return this.properties;
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        String sanitizedEndPointUri = null;
        URI uri = null;
        if (this.endpointUri != null) {
            sanitizedEndPointUri = this.endpointUri.toString();
            uri = this.endpointUri.getUri();
        }
        if (uri != null && uri.getRawUserInfo() != null && uri.getScheme() != null && uri.getHost() != null && uri.getRawPath() != null) {
            Pattern sanitizerPattern = Pattern.compile("(.*):.*");
            Matcher sanitizerMatcher = sanitizerPattern.matcher(uri.getRawUserInfo());
            if (sanitizerMatcher.matches()) {
                sanitizedEndPointUri = uri.getScheme() + "://" + sanitizerMatcher.group(1) + ":<password>" + "@" + uri.getHost() + uri.getRawPath();
            }
            if (uri.getRawQuery() != null) {
                sanitizedEndPointUri = sanitizedEndPointUri + "?" + uri.getRawQuery();
            }
        }
        return ClassUtils.getClassName(this.getClass()) + "{endpointUri=" + sanitizedEndPointUri + ", connector=" + this.connector + ", transformer=" + this.getTransformerValue() + ", name='" + this.name + "'" + ", type='" + this.type + "'" + ", properties=" + this.properties + ", transactionConfig=" + this.transactionConfig + ", filter=" + this.filter + ", deleteUnacceptedMessages=" + this.deleteUnacceptedMessages + ", initialised=" + this.initialised + ", securityFilter=" + this.securityFilter + ", synchronous=" + this.synchronous + ", initialState=" + this.initialState + ", createConnector=" + this.createConnector + ", remoteSync=" + this.remoteSync + ", remoteSyncTimeout=" + this.remoteSyncTimeout + ", endpointEncoding=" + this.endpointEncoding + "}";
    }

    public String getProtocol() {
        return this.connector.getProtocol();
    }

    public boolean canReceive() {
        return this.getType().equals("receiver") || this.getType().equals("senderAndReceiver");
    }

    public boolean canSend() {
        return this.getType().equals("sender") || this.getType().equals("senderAndReceiver");
    }

    public UMOTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableMuleEndpoint)) {
            return false;
        }
        ImmutableMuleEndpoint immutableMuleProviderDescriptor = (ImmutableMuleEndpoint)o;
        if (!this.connector.getName().equals(immutableMuleProviderDescriptor.connector.getName())) {
            return false;
        }
        if (this.endpointUri != null && immutableMuleProviderDescriptor.endpointUri != null ? !this.endpointUri.getAddress().equals(immutableMuleProviderDescriptor.endpointUri.getAddress()) : immutableMuleProviderDescriptor.endpointUri != null) {
            return false;
        }
        if (!this.name.equals(immutableMuleProviderDescriptor.name)) {
            return false;
        }
        return this.type.equals(immutableMuleProviderDescriptor.type);
    }

    public int hashCode() {
        int result = this.appendHash(0, this.connector);
        result = this.appendHash(result, this.endpointUri);
        result = this.appendHash(result, this.name);
        result = this.appendHash(result, this.type);
        return result;
    }

    private int appendHash(int hash, Object component) {
        int delta = component != null ? component.hashCode() : 0;
        return 29 * hash + delta;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public boolean isDeleteUnacceptedMessages() {
        return this.deleteUnacceptedMessages;
    }

    public void initialise() throws InitialisationException {
        String rsTimeout;
        String rs;
        if (this.initialised.get()) {
            logger.debug((Object)("Already initialised: " + this.toString()));
            return;
        }
        this.endpointUri.initialise();
        if (this.endpointEncoding == null) {
            this.endpointEncoding = RegistryContext.getConfiguration().getDefaultEncoding();
        }
        if (this.connector == null) {
            if (this.endpointUri.getConnectorName() != null) {
                this.connector = this.managementContext.getRegistry().lookupConnector(this.endpointUri.getConnectorName());
                if (this.connector == null) {
                    throw new IllegalArgumentException("Connector not found: " + this.endpointUri.getConnectorName());
                }
            } else {
                try {
                    this.connector = TransportFactory.getOrCreateConnectorByProtocol(this);
                    if (this.connector == null) {
                        throw new InitialisationException(CoreMessages.connectorWithProtocolNotRegistered(this.endpointUri.getScheme()), (Initialisable)this);
                    }
                }
                catch (TransportFactoryException e) {
                    throw new InitialisationException(CoreMessages.failedToCreateConnectorFromUri(this.endpointUri), (Throwable)e, this);
                }
            }
            if (this.endpointUri.getEndpointName() != null && this.name == null) {
                this.name = this.endpointUri.getEndpointName();
            }
        }
        this.name = ObjectNameHelper.getEndpointName(this);
        String sync = this.endpointUri.getParams().getProperty("synchronous", null);
        if (sync != null) {
            this.synchronous = Boolean.valueOf(sync);
        }
        if (this.properties != null && this.endpointUri.getParams() != null) {
            this.properties.putAll(this.endpointUri.getParams());
        }
        if (!(this instanceof MuleEndpoint)) {
            this.properties = Collections.unmodifiableMap(this.properties);
        }
        if (this.endpointUri.getTransformers() != null) {
            try {
                UMOTransformer newTransformer = MuleObjectHelper.getTransformer(this.endpointUri.getTransformers(), ",");
                this.initTransformerIfNotNull(newTransformer);
            }
            catch (MuleException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        if (this.endpointUri.getResponseTransformers() != null) {
            try {
                this.responseTransformer = MuleObjectHelper.getTransformer(this.endpointUri.getResponseTransformers(), ",");
            }
            catch (MuleException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        if (this.responseTransformer == null && this.connector instanceof AbstractConnector) {
            this.responseTransformer = ((AbstractConnector)this.connector).getDefaultResponseTransformer();
        }
        if (this.responseTransformer != null) {
            this.responseTransformer.setEndpoint(this);
        }
        if (this.securityFilter != null) {
            this.securityFilter.setEndpoint(this);
            this.securityFilter.initialise();
        }
        if ((rs = (String)this.endpointUri.getParams().remove("remoteSync")) != null) {
            this.remoteSync = Boolean.valueOf(rs);
        }
        if ((rsTimeout = (String)this.endpointUri.getParams().remove("remoteSyncTimeout")) != null) {
            this.remoteSyncTimeout = Integer.valueOf(rsTimeout);
        }
        if (this.connectionStrategy == null) {
            this.connectionStrategy = new SingleAttemptConnectionStrategy();
        }
        this.initialised.set(true);
    }

    protected void lazyInitTransformer() {
        if (UninitialisedTransformer.getInstance() == this.transformer.get()) {
            UMOTransformer newTransformer = null;
            if (this.connector instanceof AbstractConnector) {
                newTransformer = "sender".equals(this.type) ? ((AbstractConnector)this.connector).getDefaultOutboundTransformer() : ("senderAndReceiver".equals(this.type) ? ((AbstractConnector)this.connector).getDefaultInboundTransformer() : ((AbstractConnector)this.connector).getDefaultInboundTransformer());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating new transformer " + newTransformer + " for endpoint " + this + " of type " + this.type));
                }
            } else {
                logger.warn((Object)("Connector " + this.connector.getName() + " does not inherit AbstractConnector"));
            }
            this.transformer.compareAndSet((Object)UninitialisedTransformer.getInstance(), (Object)newTransformer);
            this.updateTransformerEndpoint();
        }
    }

    protected void initTransformerIfNotNull(UMOTransformer newTransformer) {
        if (null != newTransformer) {
            this.transformer.compareAndSet((Object)UninitialisedTransformer.getInstance(), (Object)newTransformer);
            this.updateTransformerEndpoint();
        }
    }

    protected void updateTransformerEndpoint() {
        UMOTransformer target = this.getTransformerValue();
        if (null != target) {
            target.setEndpoint(this);
        }
    }

    public void register() throws RegistrationException {
        if (this.connector == null || this.connector.getRegistryId() == null) {
            throw new RegistrationException("Unable to find the endpoint's connector registryId");
        }
        this.registryId = this.managementContext.getRegistry().registerMuleObject(this.connector, this).getId();
    }

    public void deregister() throws DeregistrationException {
        this.managementContext.getRegistry().deregisterComponent(this.registryId);
        this.registryId = null;
    }

    public String getRegistryId() {
        return this.registryId;
    }

    public UMOEndpointSecurityFilter getSecurityFilter() {
        return this.securityFilter;
    }

    public boolean isSynchronous() {
        if (this.synchronous == null) {
            return RegistryContext.getConfiguration().isDefaultSynchronousEndpoints();
        }
        return this.synchronous;
    }

    public boolean isSynchronousSet() {
        return this.synchronous != null;
    }

    public int getCreateConnector() {
        return this.createConnector;
    }

    public boolean isRemoteSync() {
        if (this.remoteSync == null) {
            this.remoteSync = this.connector == null || this.connector.isRemoteSyncEnabled() ? Boolean.FALSE : Boolean.FALSE;
        }
        return this.remoteSync;
    }

    public int getRemoteSyncTimeout() {
        if (this.remoteSyncTimeout == null) {
            this.remoteSyncTimeout = new Integer(0);
        }
        return this.remoteSyncTimeout;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public UMOTransformer getResponseTransformer() {
        return this.responseTransformer;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public Object getProperty(Object key) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = this.endpointUri.getParams().get(key);
        }
        return value;
    }

    public void dispatch(UMOEvent event) throws DispatchException {
        if (this.connector == null) {
            throw new IllegalStateException("The connector on the endpoint: " + this.toString() + "is null. Please contact " + MuleManifest.getDevListEmail());
        }
        this.connector.dispatch(this, event);
    }

    public UMOMessage receive(long timeout) throws Exception {
        if (this.connector != null) {
            return this.connector.receive(this, timeout);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + "is null. Please contact " + MuleManifest.getDevListEmail());
    }

    public UMOMessage send(UMOEvent event) throws DispatchException {
        if (this.connector != null) {
            return this.connector.send(this, event);
        }
        throw new IllegalStateException("The connector on the endpoint: " + this.toString() + "is null. Please contact " + MuleManifest.getDevListEmail());
    }

    public UMOManagementContext getManagementContext() {
        return this.managementContext;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }
}

