/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.RegistryContext;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.model.UMOModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class RegisterServicePostProcessor
implements BeanPostProcessor {
    protected final transient Log logger = LogFactory.getLog((Class)RegisterServicePostProcessor.class);

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof UMODescriptor) {
            UMOModel model;
            UMODescriptor descriptor = (UMODescriptor)bean;
            if (descriptor.getModelName() == null) {
                this.logger.warn((Object)"No model name set on the service descriptor. Attempting to use default: main");
                descriptor.setModelName("main");
            }
            if ((model = RegistryContext.getRegistry().lookupModel(descriptor.getModelName())) == null) {
                throw new IllegalArgumentException("No model named '" + descriptor.getModelName() + "' registered. Offending service is: " + descriptor);
            }
            try {
                model.registerComponent(descriptor);
            }
            catch (UMOException e) {
                throw new BeanInitializationException("failed to register service with model: " + descriptor, (Throwable)e);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

