/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.processors;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.mule.RegistryContext;
import org.mule.config.PropertyFactory;
import org.mule.config.i18n.CoreMessages;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class PropertyPlaceholderProcessor
extends PropertyPlaceholderConfigurer {
    private Map factories = new HashMap();

    protected Properties mergeProperties() throws IOException {
        Properties props = super.mergeProperties();
        Map p = RegistryContext.getRegistry().lookupProperties();
        if (p != null) {
            props.putAll((Map<?, ?>)p);
        }
        if (this.factories != null) {
            Iterator iterator = this.factories.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getKey() == null) {
                    throw new NullPointerException(CoreMessages.objectIsNull("Factories.Key").getMessage());
                }
                if (entry.getValue() == null) {
                    throw new NullPointerException(CoreMessages.objectIsNull("Factories.Value").getMessage());
                }
                try {
                    props.put(entry.getKey(), ((PropertyFactory)entry.getValue()).create(props));
                }
                catch (Exception e) {
                    throw new IOException("Failed to invoke PropertyFactory: " + entry.getValue() + ". Error is: " + e.toString());
                }
            }
        }
        return props;
    }

    public Map getFactories() {
        return this.factories;
    }

    public void setFactories(Map factories) {
        this.factories = factories;
    }
}

