/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.impl.MuleDescriptor;
import org.mule.util.StringUtils;
import org.mule.util.object.SimpleObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ServiceDescriptorDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    protected Class getBeanClass(Element element) {
        return MuleDescriptor.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element parent = (Element)element.getParentNode();
        String modelName = parent.getAttribute("name");
        builder.addPropertyValue("modelName", (Object)modelName);
        builder.setSingleton(true);
        builder.addDependsOn(modelName);
        String implClass = element.getAttribute("implementation");
        if (StringUtils.isNotBlank((String)implClass)) {
            BeanDefinitionBuilder serviceFactory = BeanDefinitionBuilder.rootBeanDefinition((Class)SimpleObjectFactory.class);
            serviceFactory.addPropertyValue("objectClassName", (Object)implClass);
            String serviceName = element.getAttribute("name") + "-factory";
            builder.addPropertyReference("serviceFactory", serviceName);
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)serviceFactory.getBeanDefinition(), serviceName);
            this.registerBeanDefinition(holder, parserContext.getRegistry());
            element.removeAttribute("implementation");
        }
        super.doParse(element, parserContext, builder);
    }
}

