/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.spring.parsers.AbstractChildDefinitionParser;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class EndpointDefinitionParser
extends AbstractChildDefinitionParser {
    public static final String ADDRESS_ATTRIBUTE = "address";
    public static final String ENDPOINT_REF_ATTRIBUTE = "ref";

    public EndpointDefinitionParser() {
        this.addAlias(ADDRESS_ATTRIBUTE, "endpointURI");
        this.addMapping("createConnector", "GET_OR_CREATE=0,ALWAYS_CREATE=1,NEVER_CREATE=2");
        this.addAlias("transformers", "transformer");
        this.addAlias("responseTransformers", "responseTransformer");
        this.addIgnored(ENDPOINT_REF_ATTRIBUTE);
    }

    public String getPropertyName(Element e) {
        Element parent = (Element)e.getParentNode();
        if (parent.getNodeName().equals("beans")) {
            return null;
        }
        return "endpoint";
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element parent = (Element)element.getParentNode();
        if (parent.getNodeName().equals("beans")) {
            builder.addPropertyValue("type", (Object)"global");
            if (null == element.getAttributeNode(ADDRESS_ATTRIBUTE)) {
                throw new IllegalStateException("A global endpoint requires an address attribute.");
            }
            if (null != element.getAttributeNode(ENDPOINT_REF_ATTRIBUTE)) {
                throw new IllegalStateException("A global endpoint cannot contain a ref attribute.");
            }
        } else if (null == element.getAttributeNode(ADDRESS_ATTRIBUTE)) {
            if (null == element.getAttributeNode(ENDPOINT_REF_ATTRIBUTE)) {
                throw new IllegalStateException("An endpoint requires either an address or a ref attribute.");
            }
        } else if (null != element.getAttributeNode(ENDPOINT_REF_ATTRIBUTE)) {
            throw new IllegalStateException("The address and ref attributes are mutually exclusive.");
        }
        if (StringUtils.isNotBlank((String)element.getAttribute("connector"))) {
            builder.addDependsOn(element.getAttribute("connector"));
        }
        this.processTransformerDependencies(builder, element, "transformers");
        this.processTransformerDependencies(builder, element, "responseTransformers");
        super.parseChild(element, parserContext, builder);
    }

    protected void processTransformerDependencies(BeanDefinitionBuilder builder, Element element, String attributeName) {
        if (StringUtils.isNotBlank((String)element.getAttribute(attributeName))) {
            String[] trans = StringUtils.split((String)element.getAttribute(attributeName), (String)" ,;");
            for (int i = 0; i < trans.length; ++i) {
                builder.addDependsOn(trans[i]);
            }
        }
    }

    protected Class getBeanClass(Element element) {
        return MuleEndpoint.class;
    }

    protected BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, Class beanClass) {
        if (null == element.getAttributeNode(ENDPOINT_REF_ATTRIBUTE)) {
            return super.createBeanDefinitionBuilder(element, beanClass);
        }
        String parent = element.getAttribute(ENDPOINT_REF_ATTRIBUTE);
        BeanDefinitionBuilder bdb = BeanDefinitionBuilder.childBeanDefinition((String)parent);
        bdb.getBeanDefinition().setBeanClassName(beanClass.getName());
        bdb.addPropertyValue("type", (Object)"senderAndReceiver");
        return bdb;
    }

    protected String generateChildBeanName(Element e) {
        if (null != e.getAttributeNode(ENDPOINT_REF_ATTRIBUTE)) {
            return "ref:" + e.getAttribute(ENDPOINT_REF_ATTRIBUTE);
        }
        return super.generateChildBeanName(e);
    }
}

