/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.specific;

import org.mule.config.i18n.CoreMessages;
import org.mule.config.spring.parsers.AbstractChildDefinitionParser;
import org.mule.providers.SimpleRetryConnectionStrategy;
import org.mule.util.ClassUtils;
import org.springframework.beans.FatalBeanException;
import org.w3c.dom.Element;

public class ConnectionStrategyDefinitionParser
extends AbstractChildDefinitionParser {
    public static final Class DEFAULT_CONNECTION_STRATEGY = SimpleRetryConnectionStrategy.class;

    protected Class getBeanClass(Element element) {
        String clazz = element.getAttribute("class");
        if (clazz != null) {
            try {
                return ClassUtils.loadClass(clazz, ((Object)((Object)this)).getClass());
            }
            catch (ClassNotFoundException e) {
                throw new FatalBeanException(CoreMessages.cannotLoadFromClasspath(clazz).getMessage(), (Throwable)e);
            }
        }
        return DEFAULT_CONNECTION_STRATEGY;
    }

    public String getPropertyName(Element e) {
        String name = e.getLocalName();
        if ("receiver-connection-strategy".equals(name)) {
            return "receiverConnectionStrategy";
        }
        if ("dispatcher-connection-strategy".equals(name)) {
            return "dispatcherConnectionStrategy";
        }
        if (name.startsWith("default-")) {
            return null;
        }
        return "connectionStrategy";
    }
}

