/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.generic;

import org.mule.config.spring.parsers.AbstractHierarchicalDefinitionParser;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;

public class ParentDefinitionParser
extends AbstractHierarchicalDefinitionParser {
    public static final String COMPOUND_ELEMENT = "compound";

    protected Class getBeanClass(Element element) {
        try {
            return Class.forName(this.getParentBeanDefinition(element).getBeanClassName());
        }
        catch (Exception e) {
            this.logger.debug((Object)("No class for " + element));
            return Object.class;
        }
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        this.setRegistry(parserContext.getRegistry());
        this.parserContext = parserContext;
        Class beanClass = this.getBeanClass(element);
        Assert.state((beanClass != null ? 1 : 0) != 0, (String)("Class returned from getBeanClass(Element) must not be null, element is: " + element.getNodeName()));
        BeanDefinitionBuilder builder = this.createBeanDefinitionBuilder(element, beanClass);
        builder.setSource(parserContext.extractSource((Object)element));
        if (parserContext.isNested()) {
            builder.setSingleton(parserContext.getContainingBeanDefinition().isSingleton());
        }
        this.doParse(element, parserContext, builder);
        BeanAssembler beanAssembler = this.getBeanAssembler(element, builder);
        beanAssembler.copyBeanToTarget();
        beanAssembler.getTarget().setAttribute(COMPOUND_ELEMENT, (Object)Boolean.TRUE);
        return (AbstractBeanDefinition)beanAssembler.getTarget();
    }

    protected void postProcess(BeanDefinitionBuilder beanDefinition, Element element) {
        if (null == element.getAttributeNode("name")) {
            element.setAttribute("name", this.getParentBeanName(element));
        }
    }
}

