/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.assembly;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.springframework.core.Conventions;

public class PropertyConfiguration {
    public static final String ATTRIBUTE_REF_SUFFIX = "-ref";
    private List references = new ArrayList();
    private Properties nameMappings = new Properties();
    private Map valueMappings = new HashMap();
    private Set collections = new HashSet();
    private Set ignored = new HashSet();
    private Log logger = LogFactory.getLog(this.getClass());

    public void addReference(String propertyName) {
        this.references.add(propertyName);
    }

    public void addMapping(ValueMap mapping) {
        this.valueMappings.put(mapping.getPropertyName(), mapping);
    }

    public void addMapping(String propertyName, Map mappings) {
        this.valueMappings.put(propertyName, new ValueMap(propertyName, mappings));
    }

    public void addMapping(String propertyName, String mappings) {
        this.valueMappings.put(propertyName, new ValueMap(propertyName, mappings));
    }

    public void addAlias(String alias, String propertyName) {
        this.nameMappings.put(alias, propertyName);
    }

    public void addCollection(String propertyName) {
        this.collections.add(propertyName);
    }

    public void addIgnored(String propertyName) {
        this.ignored.add(propertyName);
    }

    public String getAttributeMapping(String alias) {
        return this.nameMappings.getProperty(alias, alias);
    }

    public boolean isCollection(String propertyName) {
        return this.collections.contains(propertyName);
    }

    public boolean isIgnored(String propertyName) {
        return this.ignored.contains(propertyName);
    }

    protected String bestGuessName(String oldName, String className) {
        String newName = this.translateName(oldName);
        if (!this.methodExists(className, newName)) {
            String pluraly;
            String plural = newName + "s";
            if (this.methodExists(className, plural)) {
                this.addCollection(plural);
                return plural;
            }
            if (newName.endsWith("y") && this.methodExists(className, pluraly = newName.substring(0, newName.length() - 1) + "ies")) {
                this.addCollection(pluraly);
                return pluraly;
            }
        }
        return newName;
    }

    protected boolean methodExists(String className, String newName) {
        try {
            Class clazz = ClassUtils.getClass((String)className);
            Method[] methods = clazz.getMethods();
            String setter = "set" + newName;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equalsIgnoreCase(setter)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)("Could not access bean class " + className), (Throwable)e);
        }
        return false;
    }

    public boolean isBeanReference(String attributeName) {
        return this.references.contains(attributeName) || attributeName.endsWith(ATTRIBUTE_REF_SUFFIX);
    }

    public String translateName(String oldName) {
        String name = StringUtils.chomp((String)oldName, (String)ATTRIBUTE_REF_SUFFIX);
        name = this.getAttributeMapping(name);
        if (!org.springframework.util.StringUtils.hasText((String)(name = Conventions.attributeNameToPropertyName((String)name)))) {
            throw new IllegalStateException("Illegal property name for " + oldName + ": cannot be null or empty.");
        }
        return name;
    }

    public String translateValue(String name, String value) {
        ValueMap vm = (ValueMap)this.valueMappings.get(name);
        if (vm != null) {
            Object v = vm.getValue(value);
            if (v != null) {
                return v.toString();
            }
            return value;
        }
        return value;
    }

    public static class ValueMap {
        private String propertyName;
        private Map mappings;

        public ValueMap(String propertyName, String mappingsString) {
            this.propertyName = propertyName;
            this.mappings = new HashMap();
            String[] values = org.springframework.util.StringUtils.tokenizeToStringArray((String)mappingsString, (String)",");
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                int x = value.indexOf("=");
                if (x == -1) {
                    throw new IllegalArgumentException("Mappings string not properly defined: " + mappingsString);
                }
                this.mappings.put(value.substring(0, x), value.substring(x + 1));
            }
        }

        public ValueMap(String propertyName, Map mappings) {
            this.propertyName = propertyName;
            this.mappings = mappings;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Object getValue(Object key) {
            return this.mappings.get(key);
        }
    }
}

