/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.assembly;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.PropertyConfiguration;
import org.mule.config.spring.parsers.collection.ChildListEntryDefinitionParser;
import org.mule.config.spring.parsers.collection.ChildMapEntryDefinitionParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.w3c.dom.Attr;

public class DefaultBeanAssembler
implements BeanAssembler {
    private PropertyConfiguration beanConfig;
    private BeanDefinitionBuilder bean;
    private PropertyConfiguration targetConfig;
    private BeanDefinition target;

    public DefaultBeanAssembler(PropertyConfiguration beanConfig, BeanDefinitionBuilder bean, PropertyConfiguration targetConfig, BeanDefinition target) {
        this.beanConfig = beanConfig;
        this.bean = bean;
        this.targetConfig = targetConfig;
        this.target = target;
    }

    public BeanDefinitionBuilder getBean() {
        return this.bean;
    }

    public BeanDefinition getTarget() {
        return this.target;
    }

    public void extendBean(Attr attribute) {
        String oldName = DefaultBeanAssembler.attributeName(attribute);
        String oldValue = attribute.getNodeValue();
        String newName = this.beanConfig.bestGuessName(oldName, this.bean.getBeanDefinition().getBeanClassName());
        String newValue = this.beanConfig.translateValue(oldName, oldValue);
        if (!this.beanConfig.isIgnored(oldName)) {
            this.extendBean(newName, newValue, this.beanConfig.isBeanReference(oldName));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void extendBean(String newName, Object newValue, boolean isReference) {
        if (isReference) {
            if (!(newValue instanceof String)) throw new IllegalArgumentException("Bean reference must be a String: " + newName + "/" + newValue);
            this.bean.addPropertyReference(newName, (String)newValue);
            return;
        } else {
            this.bean.addPropertyValue(newName, newValue);
        }
    }

    public void extendTarget(Attr attribute) {
        String oldName = DefaultBeanAssembler.attributeName(attribute);
        String oldValue = attribute.getNodeValue();
        String newName = this.targetConfig.bestGuessName(oldName, this.bean.getBeanDefinition().getBeanClassName());
        String newValue = this.targetConfig.translateValue(oldName, oldValue);
        if (!this.targetConfig.isIgnored(oldName)) {
            this.extendTarget(newName, newValue, this.targetConfig.isBeanReference(oldName));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void extendTarget(String newName, Object newValue, boolean isReference) {
        this.assertTargetPresent();
        if (isReference) {
            if (!(newValue instanceof String)) throw new IllegalArgumentException("Bean reference must be a String: " + newName + "/" + newValue);
            this.target.getPropertyValues().addPropertyValue(newName, (Object)new RuntimeBeanReference((String)newValue));
            return;
        } else {
            this.target.getPropertyValues().addPropertyValue(newName, newValue);
        }
    }

    public void insertBeanInTarget(String oldName) {
        this.assertTargetPresent();
        String newName = this.targetConfig.bestGuessName(oldName, this.target.getBeanClassName());
        Object source = this.bean.getBeanDefinition().getSource();
        PropertyValue pv = this.target.getPropertyValues().getPropertyValue(newName);
        if (!this.targetConfig.isIgnored(oldName)) {
            if (source instanceof ChildMapEntryDefinitionParser.KeyValuePair) {
                if (pv == null) {
                    pv = new PropertyValue(newName, (Object)new ManagedMap());
                }
                ChildMapEntryDefinitionParser.KeyValuePair pair = (ChildMapEntryDefinitionParser.KeyValuePair)source;
                ((Map)pv.getValue()).put(pair.getKey(), pair.getValue());
            } else if (this.targetConfig.isCollection(newName) || source instanceof ChildListEntryDefinitionParser.ListEntry) {
                if (pv == null) {
                    pv = new PropertyValue(newName, (Object)new ManagedList());
                }
                List list = (List)pv.getValue();
                if (source instanceof ChildListEntryDefinitionParser.ListEntry) {
                    ChildListEntryDefinitionParser.ListEntry entry = (ChildListEntryDefinitionParser.ListEntry)source;
                    list.add(entry.getProxiedObject());
                } else {
                    list.add(this.bean.getBeanDefinition());
                }
            } else {
                pv = new PropertyValue(newName, (Object)this.bean.getBeanDefinition());
            }
            this.target.getPropertyValues().addPropertyValue(pv);
        }
    }

    public void copyBeanToTarget() {
        this.assertTargetPresent();
        MutablePropertyValues targetProperties = this.target.getPropertyValues();
        MutablePropertyValues beanProperties = this.bean.getBeanDefinition().getPropertyValues();
        for (int i = 0; i < beanProperties.size(); ++i) {
            PropertyValue propertyValue = beanProperties.getPropertyValues()[i];
            String name = propertyValue.getName();
            Object value = propertyValue.getValue();
            Object oldValue = null;
            if (targetProperties.contains(name)) {
                oldValue = targetProperties.getPropertyValue(name).getValue();
            }
            if (this.targetConfig.isCollection(name) || oldValue instanceof Collection || value instanceof Collection) {
                ManagedList values = new ManagedList();
                if (null != oldValue) {
                    targetProperties.removePropertyValue(name);
                    if (oldValue instanceof Collection) {
                        values.addAll((Collection)oldValue);
                    } else {
                        values.add(oldValue);
                    }
                }
                if (value instanceof Collection) {
                    values.addAll((Collection)value);
                } else {
                    values.add(value);
                }
                targetProperties.addPropertyValue(name, (Object)values);
                continue;
            }
            targetProperties.addPropertyValue(name, value);
        }
    }

    public static String attributeName(Attr attribute) {
        String name = attribute.getLocalName();
        if (null == name) {
            name = attribute.getName();
        }
        return name;
    }

    protected void assertTargetPresent() {
        if (null == this.target) {
            throw new IllegalStateException("Bean assembler does not have a target");
        }
    }
}

