/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.assembly.BeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.DefaultBeanAssemblerFactory;
import org.mule.config.spring.parsers.assembly.PropertyConfiguration;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractMuleBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_IDREF = "nameref";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String ATTRIBUTE_REF_SUFFIX = "-ref";
    public static final String BASE_NAME = "autogenNameForMule-";
    private static AtomicInteger nameCount = new AtomicInteger(0);
    protected transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected BeanAssemblerFactory beanAssemblerFactory = new DefaultBeanAssemblerFactory();
    protected PropertyConfiguration propertyConfiguration = new PropertyConfiguration();
    protected Properties attributeMappings;
    protected Map valueMappings;
    protected List beanReferences;
    protected ParserContext parserContext;
    protected boolean singleton = false;
    protected boolean allowClassAttribute = true;
    private BeanDefinitionRegistry registry;

    public AbstractMuleBeanDefinitionParser() {
        this.addIgnored(ATTRIBUTE_ID);
    }

    public void addReference(String propertyName) {
        this.propertyConfiguration.addReference(propertyName);
    }

    public void addMapping(String propertyName, Map mappings) {
        this.propertyConfiguration.addMapping(propertyName, mappings);
    }

    public void addMapping(String propertyName, String mappings) {
        this.propertyConfiguration.addMapping(propertyName, mappings);
    }

    public AbstractMuleBeanDefinitionParser addAlias(String alias, String propertyName) {
        this.propertyConfiguration.addAlias(alias, propertyName);
        return this;
    }

    public AbstractMuleBeanDefinitionParser addCollection(String propertyName) {
        this.propertyConfiguration.addCollection(propertyName);
        return this;
    }

    public AbstractMuleBeanDefinitionParser addIgnored(String propertyName) {
        this.propertyConfiguration.addIgnored(propertyName);
        return this;
    }

    protected void processProperty(Attr attribute, BeanDefinitionBuilder builder) {
        this.getOrphanBeanAssembler(builder).extendBean(attribute);
    }

    protected void postProcess(BeanDefinitionBuilder beanDefinition, Element element) {
        this.guaranteeElementName(element);
    }

    protected void preProcess() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        this.parserContext = parserContext;
        this.preProcess();
        this.setRegistry(parserContext.getRegistry());
        this.checkElementNameUnique(element);
        Class beanClass = null;
        if (this.allowClassAttribute) {
            beanClass = this.getBeanClassFromAttribute(element);
        }
        if (beanClass == null) {
            beanClass = this.getBeanClass(element);
        }
        Assert.state((beanClass != null ? 1 : 0) != 0, (String)("Class returned from getBeanClass(Element) must not be null, element is: " + element.getNodeName()));
        BeanDefinitionBuilder builder = this.createBeanDefinitionBuilder(element, beanClass);
        builder.setSource(parserContext.extractSource((Object)element));
        builder.setSingleton(this.isSingleton());
        builder.addDependsOn("_muleRegistry");
        List interfaces = ClassUtils.getAllInterfaces((Class)beanClass);
        if (interfaces != null) {
            if (interfaces.contains(Initialisable.class)) {
                builder.setInitMethodName("initialise");
            }
            if (interfaces.contains(Disposable.class)) {
                builder.setDestroyMethodName("dispose");
            }
        }
        if (parserContext.isNested()) {
            builder.setSingleton(parserContext.getContainingBeanDefinition().isSingleton());
        }
        this.doParse(element, parserContext, builder);
        return builder.getBeanDefinition();
    }

    protected void setRegistry(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    protected BeanDefinitionRegistry getRegistry() {
        if (null == this.registry) {
            throw new IllegalStateException("Set the registry from within doParse");
        }
        return this.registry;
    }

    protected void checkElementNameUnique(Element element) {
        if (null != element.getAttributeNode(ATTRIBUTE_NAME)) {
            String name = element.getAttribute(ATTRIBUTE_NAME);
            if (this.getRegistry().containsBeanDefinition(name)) {
                throw new IllegalArgumentException("A component named " + name + " already exists.");
            }
        }
    }

    protected void guaranteeElementName(Element element) {
        if (null == element.getAttributeNode(ATTRIBUTE_NAME)) {
            element.setAttribute(ATTRIBUTE_NAME, BASE_NAME + nameCount.incrementAndGet());
        }
    }

    protected BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, Class beanClass) {
        return BeanDefinitionBuilder.rootBeanDefinition((Class)beanClass);
    }

    protected Class getBeanClassFromAttribute(Element element) {
        String className = element.getAttribute(ATTRIBUTE_CLASS);
        Class clazz = null;
        if (StringUtils.isNotBlank((String)className)) {
            try {
                element.removeAttribute(ATTRIBUTE_CLASS);
                clazz = ClassUtils.loadClass(className, ((Object)((Object)this)).getClass());
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)("could not load class: " + className), (Throwable)e);
            }
        }
        return clazz;
    }

    protected abstract Class getBeanClass(Element var1);

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            this.processProperty(attribute, builder);
        }
        this.postProcess(builder, element);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = element.getAttribute(ATTRIBUTE_NAME);
        if (org.springframework.util.StringUtils.hasText((String)name)) {
            return name;
        }
        return super.resolveId(element, definition, parserContext);
    }

    protected boolean isSingleton() {
        return this.singleton;
    }

    protected BeanAssembler getOrphanBeanAssembler(BeanDefinitionBuilder bean) {
        return this.beanAssemblerFactory.newBeanAssembler(this.propertyConfiguration, bean, this.propertyConfiguration, null);
    }
}

