/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers;

import org.mule.config.spring.parsers.AbstractHierarchicalDefinitionParser;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractChildDefinitionParser
extends AbstractHierarchicalDefinitionParser {
    protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.setRegistry(parserContext.getRegistry());
        this.parseChild(element, parserContext, builder);
    }

    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setSingleton(this.isSingleton());
        super.doParse(element, parserContext, builder);
    }

    protected void postProcess(BeanDefinitionBuilder builder, Element element) {
        String name = this.generateChildBeanName(element);
        element.setAttribute("name", name);
        if (this.getPropertyName(element) == null) {
            return;
        }
        this.getBeanAssembler(element, builder).insertBeanInTarget(this.getPropertyName(element));
    }

    protected String generateChildBeanName(Element e) {
        String parentId = this.getParentBeanName(e);
        String id = e.getAttribute("name");
        if (StringUtils.isBlank((String)id)) {
            if (!parentId.startsWith(".")) {
                parentId = "." + parentId;
            }
            return parentId + ":" + e.getLocalName();
        }
        return id;
    }

    public abstract String getPropertyName(Element var1);
}

