/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.jndi;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.spring.MuleApplicationContext;
import org.mule.config.spring.jndi.DefaultSpringJndiContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;

public class SpringInitialContextFactory
implements InitialContextFactory {
    private static final transient Log log = LogFactory.getLog((Class)SpringInitialContextFactory.class);
    private static Map cache = new HashMap();
    private static Context singleton;

    public static Context makeInitialContext() {
        singleton = new DefaultSpringJndiContext();
        return singleton;
    }

    public Context getInitialContext(Hashtable environment) throws NamingException {
        if (singleton != null) {
            return singleton;
        }
        ClassPathResource resource = null;
        Object value = environment.get("java.naming.provider.url");
        String key = "jndi.xml";
        if (value == null) {
            resource = new ClassPathResource(key);
        } else if (value instanceof Resource) {
            resource = (Resource)value;
        } else {
            ResourceEditor editor = new ResourceEditor();
            key = value.toString();
            editor.setAsText(key);
            resource = (Resource)editor.getValue();
        }
        BeanFactory context = this.loadContext((Resource)resource, key);
        Context answer = (Context)context.getBean("jndi");
        if (answer == null) {
            log.warn((Object)("No JNDI context available in JNDI resource: " + resource));
            answer = new DefaultSpringJndiContext(environment, (Map)new ConcurrentHashMap());
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BeanFactory loadContext(Resource resource, String key) {
        Map map = cache;
        synchronized (map) {
            BeanFactory answer = (BeanFactory)cache.get(key);
            if (answer == null) {
                answer = this.createContext(resource);
                cache.put(key, answer);
            }
            return answer;
        }
    }

    protected BeanFactory createContext(Resource resource) {
        log.info((Object)("Loading JNDI context from: " + resource));
        return new MuleApplicationContext(resource.getFilename());
    }
}

