/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Map;
import org.mule.MuleException;
import org.mule.config.spring.SpringRegistry;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class StaticSpringRegistry
extends SpringRegistry {
    public static final String REGISTRY_ID = "org.mule.Registry.StaticSpring";
    protected StaticApplicationContext registryContext;

    public StaticSpringRegistry() {
        super(REGISTRY_ID, (ApplicationContext)null);
    }

    public StaticSpringRegistry(ApplicationContext applicationContext) {
        this(REGISTRY_ID, applicationContext);
    }

    public StaticSpringRegistry(String id) {
        this(id, (ApplicationContext)null);
    }

    public StaticSpringRegistry(String id, ApplicationContext applicationContext) {
        super(id);
        this.registryContext = applicationContext == null ? new StaticApplicationContext() : new StaticApplicationContext(applicationContext);
        this.registryContext.getBeanFactory().addBeanPostProcessor(new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if ((StaticSpringRegistry.this.isInitialised() || StaticSpringRegistry.this.isInitialising()) && bean instanceof Initialisable) {
                    try {
                        ((Initialisable)bean).initialise();
                    }
                    catch (InitialisationException e) {
                        throw new BeanCreationException("Failed to initialise Bean: " + e.getMessage(), (Throwable)e);
                    }
                }
                return bean;
            }
        });
        this.setApplicationContext((ApplicationContext)this.registryContext);
    }

    protected void registerSingleton(Object o) throws UMOException {
        try {
            Map m = BeanUtils.describe((Object)o);
            MutablePropertyValues mpvs = new MutablePropertyValues(m);
            this.registryContext.registerSingleton((String)m.get("name"), o.getClass(), mpvs);
        }
        catch (Exception e) {
            throw new MuleException(e);
        }
    }

    protected void registerPrototype(Object o) throws UMOException {
        try {
            Map m = BeanUtils.describe((Object)o);
            MutablePropertyValues mpvs = new MutablePropertyValues(m);
            this.registryContext.registerPrototype((String)m.get("name"), o.getClass(), mpvs);
        }
        catch (Exception e) {
            throw new MuleException(e);
        }
    }

    public UMOConnector unregisterConnector(String connectorName) throws UMOException {
        UMOConnector c = this.lookupConnector(connectorName);
        if (c != null) {
            c.dispose();
        }
        return c;
    }

    public void registerEndpoint(UMOImmutableEndpoint endpoint) throws UMOException {
        this.registerPrototype(endpoint);
    }

    public UMOImmutableEndpoint unregisterEndpoint(String endpointName) {
        UMOEndpoint ep = this.lookupEndpoint(endpointName);
        if (ep != null) {
            // empty if block
        }
        return ep;
    }

    public void registerTransformer(UMOTransformer transformer) throws UMOException {
        this.registerPrototype(transformer);
    }

    public UMOTransformer unregisterTransformer(String transformerName) {
        UMOTransformer t = this.lookupTransformer(transformerName);
        if (t != null && t instanceof Disposable) {
            ((Disposable)((Object)t)).dispose();
        }
        return t;
    }

    public void registerModel(UMOModel model) throws UMOException {
        this.registerSingleton(model);
    }

    public UMOModel unregisterModel(String name) {
        UMOModel model = this.lookupModel(name);
        if (model != null) {
            model.dispose();
        }
        return model;
    }

    public void registerAgent(UMOAgent agent) throws UMOException {
        this.registerSingleton(agent);
    }

    public UMOAgent unregisterAgent(String name) throws UMOException {
        UMOAgent agent = (UMOAgent)this.lookupObject((Object)name, UMOAgent.class);
        if (agent != null) {
            agent.dispose();
            agent.unregistered();
        }
        return agent;
    }

    public boolean isReadOnly() {
        return false;
    }
}

