/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import org.mule.config.MuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.container.MultiContainerContext;
import org.mule.impl.lifecycle.ContainerManagedLifecyclePhase;
import org.mule.impl.lifecycle.GenericLifecycleManager;
import org.mule.impl.registry.AbstractRegistry;
import org.mule.registry.ServiceDescriptor;
import org.mule.registry.ServiceDescriptorFactory;
import org.mule.registry.ServiceException;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.UMOLifecycleManager;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.SpiUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringRegistry
extends AbstractRegistry
implements ApplicationContextAware {
    public static final String REGISTRY_ID = "org.mule.Registry.Spring";
    protected ApplicationContext applicationContext;
    protected MultiContainerContext containerContext;

    public SpringRegistry() {
        super(REGISTRY_ID);
    }

    public SpringRegistry(String id) {
        super(id);
    }

    public SpringRegistry(ApplicationContext applicationContext) {
        super(REGISTRY_ID);
        this.setApplicationContext(applicationContext);
    }

    public SpringRegistry(String id, ApplicationContext applicationContext) {
        super(id);
        this.setApplicationContext(applicationContext);
    }

    protected UMOLifecycleManager createLifecycleManager() {
        GenericLifecycleManager lcm = new GenericLifecycleManager();
        lcm.registerLifecycle(new ContainerManagedLifecyclePhase("initialise", Initialisable.class, "dispose"));
        lcm.registerLifecycle(new ContainerManagedLifecyclePhase("dispose", Disposable.class, "initialise"));
        return lcm;
    }

    protected Object doLookupObject(Object key, Class returntype) throws ObjectNotFoundException {
        try {
            return this.applicationContext.getBean(key.toString());
        }
        catch (NoSuchBeanDefinitionException e) {
            if (returntype.getPackage().getName().startsWith("org.mule")) {
                throw new ObjectNotFoundException(key.toString(), (Throwable)e);
            }
            return this.doLookupInContainerContext(key, returntype);
        }
    }

    protected Object doLookupInContainerContext(Object key, Class returntype) throws ObjectNotFoundException {
        if (this.containerContext == null) {
            this.containerContext = new MultiContainerContext();
            Map containers = this.doLookupCollection(UMOContainerContext.class);
            if (containers.size() > 0) {
                Iterator iterator = containers.values().iterator();
                while (iterator.hasNext()) {
                    UMOContainerContext context = (UMOContainerContext)iterator.next();
                    this.containerContext.addContainer(context);
                }
            }
        }
        Object o = this.containerContext.getComponent(key);
        return o;
    }

    protected Map doLookupCollection(Class returntype) {
        return this.applicationContext.getBeansOfType(returntype);
    }

    public ServiceDescriptor lookupServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        Properties props = SpiUtils.findServiceDescriptor(type, name);
        if (props == null) {
            throw new ServiceException(CoreMessages.failedToLoad(type + " " + name));
        }
        return ServiceDescriptorFactory.create(type, name, props, overrides, this.applicationContext);
    }

    public void setConfiguration(MuleConfiguration config) {
        this.unsupportedOperation("setConfiguration", config);
    }

    protected synchronized MuleConfiguration getLocalConfiguration() {
        Map temp = this.applicationContext.getBeansOfType(MuleConfiguration.class, true, false);
        if (temp.size() > 0) {
            return (MuleConfiguration)temp.values().toArray()[temp.size() - 1];
        }
        return null;
    }

    public TransactionManager getTransactionManager() {
        Map m = this.applicationContext.getBeansOfType(TransactionManager.class);
        if (m.size() > 0) {
            return (TransactionManager)m.values().iterator().next();
        }
        return null;
    }

    public Map getModels() {
        return this.applicationContext.getBeansOfType(UMOModel.class);
    }

    public Map getConnectors() {
        return this.applicationContext.getBeansOfType(UMOConnector.class);
    }

    public Map getAgents() {
        return this.applicationContext.getBeansOfType(UMOAgent.class);
    }

    public Map getEndpoints() {
        return this.applicationContext.getBeansOfType(UMOImmutableEndpoint.class);
    }

    public Map getTransformers() {
        return this.applicationContext.getBeansOfType(UMOTransformer.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRemote() {
        return false;
    }
}

