/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MuleHierarchicalBeanDefinitionParserDelegate
extends BeanDefinitionParserDelegate {
    public static final String MULE_DEFAULT_NAMESPACE = "http://www.mulesource.org/schema/mule/core";
    protected static final Log logger = LogFactory.getLog((Class)MuleHierarchicalBeanDefinitionParserDelegate.class);

    public MuleHierarchicalBeanDefinitionParserDelegate(XmlReaderContext readerContext) {
        super(readerContext);
    }

    public BeanDefinition parseCustomElement(Element ele, BeanDefinition containingBd) {
        BeanDefinition bd = containingBd;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parsing: " + this.writeNode(ele)));
        }
        if (!this.tryParsingSpringPropertyElements(ele, bd)) {
            String namespaceUri = ele.getNamespaceURI();
            NamespaceHandler handler = this.getReaderContext().getNamespaceHandlerResolver().resolve(namespaceUri);
            if (handler == null) {
                this.getReaderContext().error("Unable to locate NamespaceHandler for namespace [" + namespaceUri + "]", (Object)ele);
                return null;
            }
            bd = handler.parse(ele, new ParserContext(this.getReaderContext(), (BeanDefinitionParserDelegate)this, containingBd));
            this.registerBean(ele, bd);
        }
        BeanDefinition root = bd;
        NodeList list = ele.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Element)) continue;
            Element element = (Element)list.item(i);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("parsing: " + this.writeNode(element)));
            }
            if (this.tryParsingSpringPropertyElements(element, bd)) continue;
            bd = this.parseCustomElement(element, bd);
            this.registerBean(element, bd);
        }
        return root;
    }

    protected boolean tryParsingSpringPropertyElements(Element element, BeanDefinition bd) {
        String ns = element.getNamespaceURI();
        if (StringUtils.isNotBlank((String)ns) && ns.startsWith(MULE_DEFAULT_NAMESPACE)) {
            if ("property".equals(element.getLocalName())) {
                this.parsePropertyElement(element, bd);
                return true;
            }
            if ("map".equals(element.getLocalName())) {
                this.parseMapElement(element, bd);
                return true;
            }
            if ("list".equals(element.getLocalName())) {
                this.parseListElement(element, bd);
                return true;
            }
            if ("set".equals(element.getLocalName())) {
                this.parseSetElement(element, bd);
                return true;
            }
        } else if ("http://www.springframework.org/schema/beans".equals(ns)) {
            return true;
        }
        return false;
    }

    private String writeNode(Element e) {
        StringBuffer buf = new StringBuffer();
        buf.append(e.getTagName()).append("{");
        for (int i = 0; i < e.getAttributes().getLength(); ++i) {
            Node n = e.getAttributes().item(i);
            buf.append(n.getLocalName()).append("=").append(n.getNodeValue()).append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    protected void registerBean(Element ele, BeanDefinition bd) {
        if (bd == null) {
            return;
        }
        Boolean compoundElement = (Boolean)bd.getAttribute("compound");
        if (Boolean.TRUE.equals(compoundElement)) {
            return;
        }
        String name = this.generateChildBeanName(ele);
        BeanDefinitionHolder bdHolder = new BeanDefinitionHolder(bd, name);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)bdHolder, (BeanDefinitionRegistry)this.getReaderContext().getRegistry());
        this.getReaderContext().fireComponentRegistered((ComponentDefinition)new BeanComponentDefinition(bdHolder));
    }

    protected String generateChildBeanName(Element e) {
        String id = e.getAttribute("name");
        if (StringUtils.isBlank((String)id)) {
            String parentId = ((Element)e.getParentNode()).getAttribute("name");
            id = e.getLocalName();
            return "." + parentId + ":" + id;
        }
        return id;
    }
}

