/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring;

import java.util.Map;
import org.mule.impl.ManagementContextAware;
import org.mule.umo.UMOManagementContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ManagementContextPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private UMOManagementContext context;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ManagementContextAware) {
            if (this.getManagementContext() == null) {
                return bean;
            }
            ((ManagementContextAware)bean).setManagementContext(this.getManagementContext());
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    protected UMOManagementContext getManagementContext() {
        if (this.context == null) {
            Map mContexts = this.applicationContext.getBeansOfType(UMOManagementContext.class, false, true);
            if (mContexts.size() == 1) {
                this.context = (UMOManagementContext)mContexts.values().iterator().next();
            } else {
                return null;
            }
        }
        return this.context;
    }
}

