/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.util.Map;
import java.util.Properties;
import org.mule.RegistryContext;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.model.ModelFactory;
import org.mule.impl.model.seda.SedaModel;
import org.mule.impl.registry.TransientRegistry;
import org.mule.providers.service.TransportFactory;
import org.mule.routing.inbound.InboundRouterCollection;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.routing.outbound.OutboundRouterCollection;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.CreateException;
import org.mule.umo.model.UMOModel;
import org.mule.util.MuleObjectHelper;
import org.mule.util.object.SimpleObjectFactory;
import org.mule.util.object.SingletonObjectFactory;

public class QuickConfigurationBuilder
implements ConfigurationBuilder {
    private static final String MODEL_NOT_SET = "not set";
    protected UMOManagementContext managementContext;
    private UMOModel model;

    public QuickConfigurationBuilder() throws UMOException {
        this("seda", true);
    }

    public QuickConfigurationBuilder(String modeltype) throws UMOException {
        this(modeltype, true);
    }

    public QuickConfigurationBuilder(boolean startManagementContext) throws UMOException {
        this("seda", startManagementContext);
    }

    public QuickConfigurationBuilder(String modeltype, boolean startManagementContext) throws UMOException {
        if (RegistryContext.getRegistry() == null) {
            TransientRegistry registry = TransientRegistry.createNew();
            RegistryContext.setRegistry(registry);
        }
        this.managementContext = RegistryContext.getRegistry().getManagementContext();
        String defaultModelName = "default-qbuilder";
        if (this.managementContext.getRegistry().lookupModel(defaultModelName) == null) {
            this.model = !MODEL_NOT_SET.equals(modeltype) ? ModelFactory.createModel(modeltype) : ModelFactory.createModel("seda");
            this.model.setName(defaultModelName);
            this.managementContext.getRegistry().registerModel(this.model);
        }
        if (startManagementContext) {
            this.managementContext.start();
        }
    }

    public QuickConfigurationBuilder(UMOManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    public void disableAdminAgent() {
        try {
            this.managementContext.getRegistry().unregisterAgent("Mule Admin");
        }
        catch (UMOException uMOException) {
            // empty catch block
        }
    }

    public void registerModel(String modelType, String name) throws UMOException {
        UMOModel model = ModelFactory.createModel(modelType);
        model.setName(name);
        this.managementContext.getRegistry().registerModel(model);
    }

    public UMODescriptor registerComponentInstance(Object component, String name, UMOEndpointURI listenerEndpointUri) throws UMOException {
        return this.registerComponentInstance(component, name, listenerEndpointUri, null);
    }

    public UMODescriptor registerComponentInstance(Object component, String name, UMOEndpointURI listenerEndpointUri, UMOEndpointURI sendEndpointUri) throws UMOException {
        UMOEndpoint inboundProvider = null;
        UMOEndpoint outboundProvider = null;
        if (listenerEndpointUri != null) {
            inboundProvider = TransportFactory.createEndpoint(listenerEndpointUri, "receiver");
        }
        if (sendEndpointUri != null) {
            outboundProvider = TransportFactory.createEndpoint(sendEndpointUri, "sender");
        }
        return this.registerComponentInstance(component, name, inboundProvider, outboundProvider);
    }

    public UMODescriptor registerComponentInstance(Object component, String name, UMOEndpoint listenerEndpoint, UMOEndpoint sendEndpoint) throws UMOException {
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setName(name);
        descriptor.setServiceFactory(new SingletonObjectFactory(component));
        descriptor.setOutboundRouter(new OutboundRouterCollection());
        OutboundPassThroughRouter router = new OutboundPassThroughRouter();
        router.addEndpoint(listenerEndpoint);
        descriptor.getOutboundRouter().addRouter(router);
        descriptor.setInboundRouter(new InboundRouterCollection());
        descriptor.getInboundRouter().addEndpoint(sendEndpoint);
        this.managementContext.getRegistry().registerService(descriptor);
        return descriptor;
    }

    public void registerComponent(String implementation, String name, String inboundEndpoint, String outboundEndpoint, Map properties) throws UMOException {
        UMOEndpoint inEndpoint = null;
        UMOEndpoint outEndpoint = null;
        if (inboundEndpoint != null && (inEndpoint = this.managementContext.getRegistry().lookupEndpoint(inboundEndpoint)) == null) {
            inEndpoint = this.createEndpoint(inboundEndpoint, null, true);
        }
        if (outboundEndpoint != null && (outEndpoint = this.managementContext.getRegistry().lookupEndpoint(outboundEndpoint)) == null) {
            outEndpoint = this.createEndpoint(outboundEndpoint, null, false);
        }
        UMODescriptor d = this.createDescriptor(implementation, name, inEndpoint, outEndpoint, properties);
        this.registerComponent(d);
    }

    public void registerComponent(String implementation, String name, UMOEndpoint inEndpoint, UMOEndpoint outEndpoint, Map properties) throws UMOException {
        UMODescriptor d = this.createDescriptor(implementation, name, inEndpoint, outEndpoint, properties);
        this.registerComponent(d);
    }

    public void registerComponent(UMODescriptor descriptor) throws UMOException {
        this.managementContext.getRegistry().registerService(descriptor);
    }

    public void registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri) throws UMOException {
        this.registerComponent(implementation, name, inboundEndpointUri, null, null);
    }

    public void registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, Map properties) throws UMOException {
        this.registerComponent(implementation, name, inboundEndpointUri, null, properties);
    }

    public void registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri) throws UMOException {
        this.registerComponent(implementation, name, inboundEndpointUri, outboundEndpointUri, null);
    }

    public void registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri, Map properties) throws UMOException {
        UMODescriptor d = this.createDescriptor(implementation, name, inboundEndpointUri, outboundEndpointUri, properties);
        this.managementContext.getRegistry().registerService(d);
    }

    public UMODescriptor createDescriptor(String implementation, String name, String inboundEndpointUri, String outboundEndpointUri, Map properties) throws UMOException {
        MuleEndpointURI inEndpointUri = null;
        MuleEndpointURI outEndpointUri = null;
        if (inboundEndpointUri != null) {
            inEndpointUri = new MuleEndpointURI(inboundEndpointUri);
        }
        if (outboundEndpointUri != null) {
            outEndpointUri = new MuleEndpointURI(outboundEndpointUri);
        }
        return this.createDescriptor(implementation, name, inEndpointUri, outEndpointUri, properties);
    }

    public UMODescriptor createDescriptor(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri, Map properties) throws UMOException {
        UMOEndpoint inboundEndpoint = null;
        UMOEndpoint outboundEndpoint = null;
        if (inboundEndpointUri != null) {
            inboundEndpoint = TransportFactory.createEndpoint(inboundEndpointUri, "receiver");
        }
        if (outboundEndpointUri != null) {
            outboundEndpoint = TransportFactory.createEndpoint(outboundEndpointUri, "sender");
        }
        return this.createDescriptor(implementation, name, inboundEndpoint, outboundEndpoint, properties);
    }

    public UMODescriptor createDescriptor(String implementation, String name, UMOEndpoint inboundEndpoint, UMOEndpoint outboundEndpoint, Map properties) throws UMOException {
        try {
            MuleDescriptor descriptor = new MuleDescriptor();
            descriptor.setServiceFactory(new SimpleObjectFactory(implementation, properties));
            descriptor.setName(name);
            descriptor.setModelName(this.getModel().getName());
            if (properties != null) {
                descriptor.getProperties().putAll(properties);
            }
            descriptor.setOutboundRouter(new OutboundRouterCollection());
            if (outboundEndpoint != null) {
                OutboundPassThroughRouter router = new OutboundPassThroughRouter();
                router.addEndpoint(outboundEndpoint);
                descriptor.getOutboundRouter().addRouter(router);
            }
            descriptor.setInboundRouter(new InboundRouterCollection());
            if (inboundEndpoint != null) {
                descriptor.getInboundRouter().addEndpoint(inboundEndpoint);
            }
            return descriptor;
        }
        catch (Exception e) {
            throw new CreateException(e, (Object)this);
        }
    }

    public void unregisterComponent(String name) throws UMOException {
        this.managementContext.getRegistry().unregisterService(name);
    }

    public UMOEndpoint createEndpoint(String uri, String name, boolean inbound) throws UMOException {
        return this.createEndpoint(uri, name, inbound, null, null);
    }

    public UMOEndpoint createEndpoint(String uri, String name, boolean inbound, String transformers) throws UMOException {
        return this.createEndpoint(uri, name, inbound, transformers, null);
    }

    public UMOEndpoint createEndpoint(String uri, String name, boolean inbound, UMOFilter filter) throws UMOException {
        return this.createEndpoint(uri, name, inbound, null, filter);
    }

    public UMOEndpoint createEndpoint(String uri, String name, boolean inbound, String transformers, UMOFilter filter) throws UMOException {
        UMOEndpoint ep = this.managementContext.getRegistry().getOrCreateEndpointForUri(new MuleEndpointURI(uri), inbound ? "receiver" : "sender");
        ep.setName(name);
        if (transformers != null) {
            String delim = transformers.indexOf(",") > -1 ? "," : " ";
            ep.setTransformer(MuleObjectHelper.getTransformer(transformers, delim));
        }
        ep.setFilter(filter);
        return ep;
    }

    public UMOEndpoint registerEndpoint(String uri, String name, boolean inbound) throws UMOException {
        UMOEndpoint ep = this.createEndpoint(uri, name, inbound);
        ep.initialise();
        this.managementContext.getRegistry().registerEndpoint(ep);
        return ep;
    }

    public UMOEndpoint registerEndpoint(String uri, String name, boolean inbound, Map properties) throws UMOException {
        UMOEndpoint ep = this.createEndpoint(uri, name, inbound);
        ep.getProperties().putAll(properties);
        ep.initialise();
        this.managementContext.getRegistry().registerEndpoint(ep);
        return ep;
    }

    public UMOEndpoint registerEndpoint(String uri, String name, boolean inbound, Map properties, UMOFilter filter) throws UMOException {
        UMOEndpoint ep = this.createEndpoint(uri, name, inbound);
        if (properties != null) {
            ep.getProperties().putAll(properties);
        }
        if (filter != null) {
            ep.setFilter(filter);
        }
        ep.initialise();
        this.managementContext.getRegistry().registerEndpoint(ep);
        return ep;
    }

    public void registerModel(UMOModel model) throws UMOException {
        this.model = model;
        this.managementContext.getRegistry().registerModel(model);
    }

    public UMOManagementContext getManagementContext() {
        return this.managementContext;
    }

    public UMOManagementContext configure(String configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManagementContext configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        return this.configure(new ReaderResource[0], null);
    }

    public UMOManagementContext configure(ReaderResource[] configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManagementContext configure(ReaderResource[] configResources, Properties startupProperties) throws ConfigurationException {
        try {
            if (!this.managementContext.isStarted()) {
                this.managementContext.start();
            }
        }
        catch (UMOException e) {
            throw new ConfigurationException(e);
        }
        return this.managementContext;
    }

    public boolean isConfigured() {
        return this.managementContext != null;
    }

    public UMOModel getModel() throws UMOException {
        if (this.model == null) {
            this.model = new SedaModel();
            this.model.setName("main");
            this.managementContext.getRegistry().registerModel(this.model);
        }
        return this.model;
    }
}

