/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.mule.RegistryContext;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.spring.MuleApplicationContext;
import org.mule.umo.UMOManagementContext;
import org.mule.util.IOUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public class MuleXmlConfigurationBuilder
implements ConfigurationBuilder {
    private String defaultConfigResource = "default-mule-config.xml";
    private boolean used = false;
    private boolean startContext = true;

    public UMOManagementContext configure(ReaderResource[] configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManagementContext configure(ReaderResource[] configResources, Properties startupProperties) throws ConfigurationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public UMOManagementContext configure(String configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManagementContext configure(String configResource, String startupPropertiesFile) throws ConfigurationException {
        if (StringUtils.isNotBlank((String)startupPropertiesFile)) {
            try {
                startupPropertiesFile = StringUtils.trimToEmpty((String)startupPropertiesFile);
                Properties startupProperties = PropertiesUtils.loadProperties(startupPropertiesFile, this.getClass());
            }
            catch (IOException e) {
                throw new ConfigurationException(CoreMessages.failedToLoad(startupPropertiesFile), (Throwable)e);
            }
        }
        if (configResource == null) {
            throw new ConfigurationException(CoreMessages.objectIsNull("Configuration Resource"));
        }
        String[] resources = org.springframework.util.StringUtils.tokenizeToStringArray((String)configResource, (String)",;", (boolean)true, (boolean)true);
        Object root = null;
        if (this.defaultConfigResource != null) {
            // empty if block
        }
        String[] all = new String[resources.length + 1];
        all[0] = this.defaultConfigResource;
        System.arraycopy(resources, 0, all, 1, resources.length);
        this.used = true;
        MuleApplicationContext context = new MuleApplicationContext(all);
        try {
            UMOManagementContext mc = context.getManagementContext();
            if (this.startContext) {
                mc.start();
            }
            RegistryContext.getConfiguration().setConfigResources(resources);
            return mc;
        }
        catch (Exception e) {
            throw new ConfigurationException(CoreMessages.failedToInvokeLifecycle("start", "Mule"), (Throwable)e);
        }
    }

    public boolean isConfigured() {
        return this.used;
    }

    protected InputStream loadConfig(String configResource) throws ConfigurationException {
        InputStream is;
        try {
            is = IOUtils.getResourceAsStream(configResource, this.getClass());
        }
        catch (IOException e) {
            throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath(configResource), (Throwable)e);
        }
        if (is != null) {
            return is;
        }
        throw new ConfigurationException(CoreMessages.cannotLoadFromClasspath(configResource));
    }

    public String getDefaultConfigResource() {
        return this.defaultConfigResource;
    }

    public void setDefaultConfigResource(String defaultConfigResource) {
        this.defaultConfigResource = defaultConfigResource;
    }

    public boolean isStartContext() {
        return this.startContext;
    }

    public void setStartContext(boolean startContext) {
        this.startContext = startContext;
    }
}

