/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import org.mule.config.ConfigurationException;
import org.mule.config.builders.QuickConfigurationBuilder;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.manager.UMOAgent;
import org.mule.util.ClassUtils;

public class MuleIdleConfigurationBuilder
extends QuickConfigurationBuilder {
    private boolean configured = false;

    public boolean isConfigured() {
        return this.configured;
    }

    public UMOManagementContext configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        try {
            Class scannerAgentClass = ClassUtils.loadClass("org.mule.impl.internal.admin.ConfigScannerAgent", MuleIdleConfigurationBuilder.class);
            UMOAgent scannerAgent = (UMOAgent)scannerAgentClass.newInstance();
            this.managementContext.getRegistry().registerAgent(scannerAgent);
            Class jmxAgentClass = ClassUtils.loadClass("org.mule.management.agents.JmxAgent", MuleIdleConfigurationBuilder.class);
            UMOAgent jmxAgent = (UMOAgent)jmxAgentClass.newInstance();
            jmxAgent.setName("jmxAgent");
            this.managementContext.getRegistry().registerAgent(jmxAgent);
            Class mx4jAgentClass = ClassUtils.loadClass("org.mule.management.agents.Mx4jAgent", MuleIdleConfigurationBuilder.class);
            UMOAgent mx4jAgent = (UMOAgent)mx4jAgentClass.newInstance();
            mx4jAgent.setName("mx4jAgent");
            this.managementContext.getRegistry().registerAgent(mx4jAgent);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        try {
            this.managementContext.start();
        }
        catch (UMOException umoe) {
            throw new ConfigurationException(umoe);
        }
        this.configured = true;
        return this.managementContext;
    }
}

