/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleShutdownHook;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.SystemUtils;

public class MuleServer
implements Runnable {
    public static final String[][] CLI_OPTIONS = new String[][]{{"builder", "true", "Configuration Builder Type"}, {"config", "true", "Configuration File"}, {"idle", "false", "Whether to run in idle (unconfigured) mode"}, {"main", "true", "Main Class"}, {"mode", "true", "Run Mode"}, {"props", "true", "Startup Properties"}};
    protected static final String CLASSNAME_DEFAULT_CONFIG_BUILDER = "org.mule.config.builders.MuleXmlConfigurationBuilder";
    protected static final String CLASSNAME_DEFAULT_IDLE_CONFIG_BUILDER = "org.mule.config.builders.MuleIdleConfigurationBuilder";
    protected static final String CLASSNAME_SPRING_CONFIG_BUILDER = "org.mule.extras.spring.config.MuleXmlConfigurationBuilder";
    private static Log logger = LogFactory.getLog((Class)MuleServer.class);
    public static final String DEFAULT_CONFIGURATION = "mule-config.xml";
    private static String shutdownMessage = null;
    private String configurationResources = null;
    private static String configBuilderClassName = null;
    private static String startupPropertiesFile = null;
    private static MuleShutdownHook muleShutdownHook;
    protected Map options = Collections.EMPTY_MAP;

    public static void main(String[] args) throws Exception {
        MuleServer server = new MuleServer(args);
        server.start(false, true);
    }

    public MuleServer() {
        this.init(new String[0]);
    }

    public MuleServer(String configResources) {
        this.init(new String[]{"-config", configResources});
    }

    public MuleServer(String[] args) throws IllegalArgumentException {
        this.init(args);
    }

    protected void init(String[] args) throws IllegalArgumentException {
        String propertiesFile;
        Map options;
        try {
            muleShutdownHook = new MuleShutdownHook(logger);
            this.registerShutdownHook(muleShutdownHook);
            options = SystemUtils.getCommandLineOptions(args, CLI_OPTIONS);
        }
        catch (MuleException me) {
            throw new IllegalArgumentException(me.toString());
        }
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
        String config = (String)options.get("config");
        if (config == null && !options.containsKey("idle")) {
            logger.warn((Object)"A configuration file was not set, using default: mule-config.xml");
            URL configUrl = IOUtils.getResourceAsUrl(DEFAULT_CONFIGURATION, MuleServer.class, true);
            if (configUrl != null) {
                config = configUrl.toExternalForm();
            } else {
                System.out.println(CoreMessages.configNotFoundUsage());
                System.exit(-1);
            }
        }
        if (config != null) {
            this.setConfigurationResources(config);
        }
        String cfgBuilderClassName = (String)options.get("builder");
        if (options.containsKey("idle")) {
            this.setConfigurationResources("IDLE");
            cfgBuilderClassName = CLASSNAME_DEFAULT_IDLE_CONFIG_BUILDER;
        }
        if (cfgBuilderClassName != null) {
            try {
                if (cfgBuilderClassName.equalsIgnoreCase("spring")) {
                    cfgBuilderClassName = CLASSNAME_SPRING_CONFIG_BUILDER;
                }
                MuleServer.setConfigBuilderClassName(cfgBuilderClassName);
            }
            catch (Exception e) {
                logger.fatal((Object)e);
                Message message = CoreMessages.failedToLoad("Builder: " + cfgBuilderClassName);
                System.err.println(StringMessageUtils.getBoilerPlate("FATAL: " + message.toString()));
                System.exit(1);
            }
        }
        if ((propertiesFile = (String)options.get("props")) != null) {
            MuleServer.setStartupPropertiesFile(propertiesFile);
        }
    }

    public void start(boolean ownThread, boolean registerShutdownHook) {
        if (registerShutdownHook) {
            this.registerShutdownHook(muleShutdownHook);
        }
        if (ownThread) {
            Thread serverThread = new Thread((Runnable)this, "MuleServer");
            serverThread.setDaemon(true);
            serverThread.start();
        } else {
            this.run();
        }
    }

    public void run() {
        try {
            this.initialize();
        }
        catch (Throwable e) {
            this.shutdown(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setConfigBuilderClassName(String builderClassName) throws ClassNotFoundException {
        if (builderClassName != null) {
            Class cls;
            if (!ConfigurationBuilder.class.isAssignableFrom(cls = ClassUtils.loadClass(builderClassName, MuleServer.class))) throw new IllegalArgumentException("Not a usable ConfigurationBuilder class: " + builderClassName);
            configBuilderClassName = builderClassName;
            return;
        } else {
            configBuilderClassName = null;
        }
    }

    public static String getConfigBuilderClassName() {
        if (configBuilderClassName != null) {
            return configBuilderClassName;
        }
        return CLASSNAME_DEFAULT_CONFIG_BUILDER;
    }

    public void initialize() throws Exception {
        logger.info((Object)"Mule Server starting...");
        Class cfgBuilderClass = ClassUtils.loadClass(MuleServer.getConfigBuilderClassName(), MuleServer.class);
        ConfigurationBuilder cfgBuilder = (ConfigurationBuilder)cfgBuilderClass.newInstance();
        if (!cfgBuilder.isConfigured()) {
            if (this.configurationResources == null) {
                logger.warn((Object)"A configuration file was not set, using default: mule-config.xml");
                this.configurationResources = DEFAULT_CONFIGURATION;
            }
            cfgBuilder.configure(this.configurationResources, MuleServer.getStartupPropertiesFile());
        }
        logger.info((Object)"Mule Server initialized.");
    }

    public void shutdown(Throwable e) {
        muleShutdownHook.setException(e);
        System.exit(-1);
    }

    public void shutdown() {
        System.exit(0);
    }

    public Log getLogger() {
        return logger;
    }

    public void registerShutdownHook(MuleShutdownHook muleShutdownHook) {
        Runtime.getRuntime().removeShutdownHook(muleShutdownHook);
        Runtime.getRuntime().addShutdownHook(muleShutdownHook);
    }

    public String getConfigurationResources() {
        return this.configurationResources;
    }

    public void setConfigurationResources(String configurationResources) {
        this.configurationResources = configurationResources;
    }

    public static String getStartupPropertiesFile() {
        return startupPropertiesFile;
    }

    public static void setStartupPropertiesFile(String startupPropertiesFile) {
        MuleServer.startupPropertiesFile = startupPropertiesFile;
    }
}

