/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.properties;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.umo.UMOMessage;
import org.mule.util.properties.PropertyExtractor;

public class PayloadPropertyExtractor
implements PropertyExtractor {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public Object getProperty(String name, Object message) {
        Object payload = message;
        if (message instanceof UMOMessage) {
            payload = ((UMOMessage)message).getPayload();
        }
        Object value = null;
        try {
            if (PropertyUtils.getPropertyDescriptor((Object)payload, (String)name) != null && (value = PropertyUtils.getProperty((Object)payload, (String)name)) == null) {
                value = "";
            }
        }
        catch (IllegalAccessException e) {
            this.logger.warn((Object)("Failed to read property: " + name), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.logger.warn((Object)("Failed to read property: " + name), e.getCause());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return value;
    }
}

