/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.filters.ObjectFilter;
import org.mule.transformers.simple.ByteArrayToString;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;

public class RegExFilter
implements UMOFilter,
ObjectFilter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private Pattern pattern;

    public RegExFilter() {
    }

    public RegExFilter(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public boolean accept(UMOMessage message) {
        return this.accept(message.getPayload());
    }

    public boolean accept(Object object) {
        if (object == null) {
            return false;
        }
        Object tempObject = object;
        if (object instanceof byte[]) {
            ByteArrayToString transformer = new ByteArrayToString();
            try {
                object = transformer.transform(object);
            }
            catch (TransformerException e) {
                this.logger.warn((Object)CoreMessages.transformFailedBeforeFilter(), (Throwable)e);
                object = tempObject;
            }
        } else if (object instanceof char[]) {
            object = new String((char[])object);
        }
        return this.pattern != null ? this.pattern.matcher(object.toString()).find() : false;
    }

    public String getPattern() {
        return this.pattern == null ? null : this.pattern.pattern();
    }

    public void setPattern(String pattern) {
        this.pattern = pattern != null ? Pattern.compile(pattern) : null;
    }
}

