/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.RequestContext;
import org.mule.impl.model.AbstractComponent;
import org.mule.management.stats.ComponentStatistics;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class DefaultComponentExceptionStrategy
extends DefaultExceptionStrategy {
    protected UMOComponent component;
    protected ComponentStatistics statistics;

    public DefaultComponentExceptionStrategy() {
    }

    public DefaultComponentExceptionStrategy(UMOComponent component) {
        this.setComponent(component);
    }

    public UMOComponent getComponent() {
        return this.component;
    }

    protected void defaultHandler(Throwable t) {
        if (this.component == null) {
            UMOEvent event = RequestContext.getEvent();
            if (event == null) {
                this.logger.fatal((Object)"The Default Component Exception Strategy has been invoked but there is no current event on the context");
                this.logger.fatal((Object)("The error is: " + t.getMessage()), t);
            } else {
                this.setComponent(event.getComponent());
            }
        }
        if (this.statistics != null) {
            this.statistics.incExecutionError();
        }
        super.defaultHandler(t);
    }

    protected void logFatal(UMOMessage message, Throwable t) {
        super.logFatal(message, t);
        if (this.statistics != null) {
            this.statistics.incFatalError();
        }
    }

    protected void routeException(UMOMessage message, UMOImmutableEndpoint failedEndpoint, Throwable t) {
        UMOEndpoint ep = this.getEndpoint(t);
        if (ep != null) {
            super.routeException(message, failedEndpoint, t);
            if (this.statistics != null) {
                this.statistics.getOutboundRouterStat().incrementRoutedMessage(ep);
            }
        }
    }

    public void setComponent(UMOComponent component) {
        this.component = component;
        if (component instanceof AbstractComponent) {
            this.statistics = ((AbstractComponent)component).getStatistics();
        }
    }
}

