/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestCaseWatchdog
extends Thread {
    protected static final Log log = LogFactory.getLog((Class)TestCaseWatchdog.class);
    protected static final AtomicInteger threadNumber = new AtomicInteger(0);
    private final long delay;
    private final TimeUnit unit;

    public TestCaseWatchdog(long delay, TimeUnit unit) {
        super("WatchdogThread-" + threadNumber.getAndIncrement());
        this.setDaemon(true);
        this.delay = delay;
        this.unit = unit;
    }

    public void run() {
        long millisToWait = this.unit.toMillis(this.delay);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting with " + millisToWait + "ms timeout."));
        }
        try {
            Thread.sleep(millisToWait);
            log.fatal((Object)("Timeout of " + millisToWait + "ms exceeded - exiting VM!"));
            Runtime.getRuntime().halt(1);
        }
        catch (InterruptedException interrupted) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Watchdog stopped.");
            }
            Thread.currentThread().interrupt();
        }
    }

    public void cancel() {
        this.interrupt();
    }
}

