/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo.security.tls;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.umo.security.tls.TlsConfiguration;

public class TlsPropertiesMapper {
    private static final String TRUST_NAME_SUFFIX = ".ssl.trustStore";
    private static final String TRUST_TYPE_SUFFIX = ".ssl.trustStoreType";
    private static final String TRUST_PASSWORD_SUFFIX = ".ssl.trustStorePassword";
    private static final String TRUST_ALGORITHM_SUFFIX = ".ssl.trustManagerAlgorithm";
    private static final String KEY_NAME_SUFFIX = ".ssl.keyStore";
    private static final String KEY_TYPE_SUFFIX = ".ssl.keyStoreType";
    private static final String KEY_PASSWORD_SUFFIX = ".ssl.keyStorePassword";
    private Log logger = LogFactory.getLog(this.getClass());
    private String namespace;

    public TlsPropertiesMapper(String namespace) {
        this.namespace = namespace;
    }

    public void writeToProperties(Properties properties, TlsConfiguration configuration) {
        this.writeTrustStoreToProperties(properties, configuration);
        this.writeKeyStoreToProperties(properties, configuration);
    }

    public void readFromProperties(TlsConfiguration configuration, Properties properties) throws IOException {
        this.readTrustStoreFromProperties(configuration, properties);
        this.readKeyStoreFromProperties(configuration, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTrustStoreToProperties(Properties properties, TlsConfiguration configuration) {
        String trustStoreName = configuration.getTrustStore();
        String trustStorePassword = configuration.getTrustStorePassword();
        if (null == trustStoreName && !configuration.isExplicitTrustStoreOnly()) {
            this.logger.info((Object)("Defaulting " + this.namespace + " trust store to client Key Store"));
            trustStoreName = configuration.getClientKeyStore();
            trustStorePassword = configuration.getClientKeyStorePassword();
        }
        if (null != trustStoreName) {
            Properties properties2 = properties;
            synchronized (properties2) {
                this.setProperty(properties, TRUST_NAME_SUFFIX, trustStoreName);
                this.setProperty(properties, TRUST_TYPE_SUFFIX, configuration.getTrustStoreType());
                this.setProperty(properties, TRUST_PASSWORD_SUFFIX, trustStorePassword);
                this.setProperty(properties, TRUST_ALGORITHM_SUFFIX, configuration.getTrustManagerAlgorithm());
            }
            this.logger.debug((Object)("Set Trust Store: " + this.namespace + TRUST_NAME_SUFFIX + " = " + trustStoreName));
        }
    }

    private void readTrustStoreFromProperties(TlsConfiguration configuration, Properties properties) throws IOException {
        configuration.setTrustStore(this.getProperty(properties, TRUST_NAME_SUFFIX, configuration.getTrustStore()));
        configuration.setTrustStoreType(this.getProperty(properties, TRUST_TYPE_SUFFIX, configuration.getTrustStoreType()));
        configuration.setTrustStorePassword(this.getProperty(properties, TRUST_PASSWORD_SUFFIX, configuration.getTrustStorePassword()));
        configuration.setTrustManagerAlgorithm(this.getProperty(properties, TRUST_ALGORITHM_SUFFIX, configuration.getTrustManagerAlgorithm()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKeyStoreToProperties(Properties properties, TlsConfiguration configuration) {
        if (null != configuration.getClientKeyStore()) {
            Properties properties2 = properties;
            synchronized (properties2) {
                this.setProperty(properties, KEY_NAME_SUFFIX, configuration.getClientKeyStore());
                this.setProperty(properties, KEY_TYPE_SUFFIX, configuration.getClientKeyStoreType());
                this.setProperty(properties, KEY_PASSWORD_SUFFIX, configuration.getClientKeyStorePassword());
            }
            this.logger.info((Object)("Set Key Store: " + this.namespace + KEY_NAME_SUFFIX + " = " + configuration.getClientKeyStore()));
        }
    }

    private void readKeyStoreFromProperties(TlsConfiguration configuration, Properties properties) throws IOException {
        configuration.setKeyStore(this.getProperty(properties, KEY_NAME_SUFFIX, configuration.getKeyStore()));
        configuration.setKeystoreType(this.getProperty(properties, KEY_TYPE_SUFFIX, configuration.getKeystoreType()));
        configuration.setStorePassword(this.getProperty(properties, KEY_PASSWORD_SUFFIX, configuration.getStorePassword()));
    }

    private void setProperty(Properties properties, String suffix, String value) {
        if (null != value) {
            properties.setProperty(this.namespace + suffix, value);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.namespace + suffix + " <- " + value));
            }
        }
    }

    private String getProperty(Properties properties, String suffix, String deflt) {
        String value = properties.getProperty(this.namespace + suffix);
        if (null == value) {
            value = deflt;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.namespace + suffix + " -> " + value));
        }
        return value;
    }
}

