/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction.lookup;

import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.container.JndiContextHelper;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOTransactionManagerFactory;
import org.mule.util.StringUtils;

public class GenericTransactionManagerLookupFactory
implements UMOTransactionManagerFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Context context;
    private Map environment;
    private TransactionManager txManager;
    private String jndiName;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public TransactionManager getTxManager() {
        return this.txManager;
    }

    public void setTxManager(TransactionManager txManager) {
        this.txManager = txManager;
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map environment) {
        this.environment = environment;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public TransactionManager create() throws Exception {
        this.initialise();
        if (this.txManager == null) {
            this.txManager = (TransactionManager)this.context.lookup(this.jndiName);
        }
        return this.txManager;
    }

    public void initialise() throws InitialisationException {
        if (this.txManager == null && StringUtils.isEmpty((String)StringUtils.trim((String)this.jndiName))) {
            throw new InitialisationException(CoreMessages.propertiesNotSet("jndiName"), (Object)this);
        }
        try {
            if (this.context == null) {
                this.context = JndiContextHelper.initialise(this.getEnvironment());
            }
        }
        catch (NamingException e) {
            throw new InitialisationException(CoreMessages.failedToCreate("Jndi context"), e, this);
        }
    }
}

