/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.nested;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.routing.UMONestedRouter;

public class NestedInvocationHandler
implements InvocationHandler {
    public static final String DEFAULT_METHOD_NAME_TOKEN = "default";
    protected static Log logger = LogFactory.getLog((Class)NestedInvocationHandler.class);
    protected Map routers = new ConcurrentHashMap();

    protected NestedInvocationHandler(UMONestedRouter router) {
        this.addRouterForInterface(router);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addRouterForInterface(UMONestedRouter router) {
        if (router.getMethod() == null) {
            if (this.routers.size() != 0) throw new IllegalArgumentException(CoreMessages.mustSetMethodNamesOnBinding().getMessage());
            this.routers.put(DEFAULT_METHOD_NAME_TOKEN, router);
            return;
        } else {
            this.routers.put(router.getMethod(), router);
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        UMOEvent currentEvent;
        MuleMessage message = new MuleMessage(args);
        UMONestedRouter router = (UMONestedRouter)this.routers.get(method.getName());
        if (router == null) {
            router = (UMONestedRouter)this.routers.get(DEFAULT_METHOD_NAME_TOKEN);
        }
        if (router == null) {
            throw new IllegalArgumentException(CoreMessages.cannotFindBindingForMethod(method.getName()).toString());
        }
        UMOEndpoint endpoint = router.getEndpoint();
        MuleEvent event = new MuleEvent((UMOMessage)message, (UMOImmutableEndpoint)endpoint, (currentEvent = RequestContext.getEvent()).getComponent(), currentEvent);
        UMOMessage reply = router.route(event);
        if (reply != null) {
            return reply.getPayload();
        }
        return null;
    }
}

