/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.mule.MuleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.routing.RoutingException;
import org.mule.util.FileUtils;

public class IdempotentReceiver
extends SelectiveConsumer {
    private static final String DEFAULT_STORE_PATH = "./idempotent";
    private Set messageIds = new HashSet();
    private File idStore;
    private String componentName;
    private boolean disablePersistence = false;
    private String storePath;

    public IdempotentReceiver() {
        String path = MuleManager.getConfiguration().getWorkingDirectory() + "/idempotent";
        this.setStorePath(path);
    }

    public boolean isMatch(UMOEvent event) throws MessagingException {
        if (this.idStore == null) {
            this.load(event);
        }
        return !this.messageIds.contains(this.getIdForEvent(event));
    }

    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        if (this.isMatch(event)) {
            try {
                this.checkComponentName(event.getComponent().getDescriptor().getName());
            }
            catch (IllegalArgumentException e) {
                throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
            Object id = this.getIdForEvent(event);
            try {
                this.storeId(id);
                return new UMOEvent[]{event};
            }
            catch (IOException e) {
                throw new RoutingException(CoreMessages.failedToWriteMessageToStore(id, this.idStore.getAbsolutePath()), event.getMessage(), event.getEndpoint(), e);
            }
        }
        return null;
    }

    protected Object getIdForEvent(UMOEvent event) throws MessagingException {
        return event.getMessage().getUniqueId();
    }

    private void checkComponentName(String name) throws IllegalArgumentException {
        if (!this.componentName.equals(name)) {
            throw new IllegalArgumentException("This receiver is assigned to component: " + this.componentName + " but has received an event for component: " + name + ". Please check your config to make sure each component" + "has its own instance of IdempotentReceiver");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void load(UMOEvent event) throws RoutingException {
        block10: {
            this.componentName = event.getComponent().getDescriptor().getName();
            if (this.idStore == null) {
                this.idStore = FileUtils.newFile(this.storePath + "/muleComponent_" + this.componentName + ".store");
            }
            if (this.disablePersistence) {
                return;
            }
            try {
                if (this.idStore.exists()) {
                    BufferedReader reader = null;
                    try {
                        String id;
                        reader = new BufferedReader(new FileReader(this.idStore));
                        while ((id = reader.readLine()) != null) {
                            this.messageIds.add(id);
                        }
                        break block10;
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                this.idStore = FileUtils.createFile(this.idStore.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RoutingException(CoreMessages.failedToReadFromStore(this.idStore.getAbsolutePath()), event.getMessage(), event.getEndpoint(), e);
            }
        }
    }

    protected synchronized void storeId(Object id) throws IOException {
        this.messageIds.add(id);
        if (this.disablePersistence) {
            return;
        }
        FileUtils.stringToFile(this.idStore.getAbsolutePath(), id.toString(), true, true);
    }

    public boolean isDisablePersistence() {
        return this.disablePersistence;
    }

    public void setDisablePersistence(boolean disablePersistence) {
        this.disablePersistence = disablePersistence;
    }

    public String getStorePath() {
        return this.storePath;
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath == null ? DEFAULT_STORE_PATH : (storePath.endsWith("/") ? (storePath = storePath.substring(0, storePath.length() - 1)) : storePath);
    }
}

