/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;

public class MessagePropertyFilter
implements UMOFilter {
    private boolean caseSensitive = true;
    private boolean not = false;
    private String propertyName;
    private String propertyValue;

    public MessagePropertyFilter() {
    }

    public MessagePropertyFilter(String expression) {
        this.setExpression(expression);
    }

    public boolean accept(UMOMessage message) {
        if (message == null) {
            return false;
        }
        Object value = message.getProperty(this.propertyName);
        if (value == null) {
            return this.compare(null, this.propertyValue);
        }
        return this.compare(value.toString(), this.propertyValue);
    }

    protected boolean compare(String value1, String value2) {
        if (value1 == null && value2 != null && !"null".equals(value2) && this.not) {
            return true;
        }
        if (value1 == null) {
            value1 = "null";
        }
        if (value2 == null) {
            value2 = "null";
        }
        boolean result = false;
        result = this.caseSensitive ? value1.equals(value2) : value1.equalsIgnoreCase(value2);
        return this.not ? !result : result;
    }

    public String getExpression() {
        return this.propertyName + '=' + this.propertyValue;
    }

    public void setExpression(String expression) {
        int i = expression.indexOf(61);
        if (i == -1) {
            throw new IllegalArgumentException("Pattern is malformed - it should be a key value pair, i.e. property=value: " + expression);
        }
        if (expression.charAt(i - 1) == '!') {
            this.not = true;
            this.propertyName = expression.substring(0, i - 1).trim();
        } else {
            this.propertyName = expression.substring(0, i).trim();
        }
        this.propertyValue = expression.substring(i + 1).trim();
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

