/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.endpoint;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Properties;
import org.mule.MuleManager;
import org.mule.impl.endpoint.EndpointBuilder;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.util.PropertiesUtils;

public abstract class AbstractEndpointBuilder
implements EndpointBuilder {
    protected String address;
    protected String endpointName;
    protected String connectorName;
    protected String transformers;
    protected String responseTransformers;
    protected String userInfo;
    protected int createConnector = 0;

    public UMOEndpointURI build(URI uri) throws MalformedEndpointException {
        Properties props = this.getPropertiesForURI(uri);
        String replaceAddress = null;
        if (this.address != null) {
            replaceAddress = this.address;
            this.setEndpoint(uri, props);
            this.address = replaceAddress;
        } else {
            this.setEndpoint(uri, props);
        }
        MuleEndpointURI ep = new MuleEndpointURI(this.address, this.endpointName, this.connectorName, this.transformers, this.responseTransformers, this.createConnector, props, uri, this.userInfo);
        this.address = null;
        this.endpointName = null;
        this.connectorName = null;
        this.transformers = null;
        this.responseTransformers = null;
        this.createConnector = 0;
        return ep;
    }

    protected abstract void setEndpoint(URI var1, Properties var2) throws MalformedEndpointException;

    protected Properties getPropertiesForURI(URI uri) throws MalformedEndpointException {
        String create;
        String cnnName;
        String endpoint;
        Properties properties = PropertiesUtils.getPropertiesFromQueryString(uri.getQuery());
        String tempEndpointName = (String)properties.get("endpointName");
        if (tempEndpointName != null) {
            this.endpointName = tempEndpointName;
        }
        if ((endpoint = (String)properties.get("address")) != null) {
            this.address = endpoint;
            this.address = this.decode(this.address, uri);
        }
        if ((cnnName = (String)properties.get("connector")) != null) {
            this.connectorName = cnnName;
        }
        if ((create = (String)properties.get("createConnector")) != null) {
            if ("0".equals(create)) {
                this.createConnector = 0;
            } else if ("1".equals(create)) {
                this.createConnector = 1;
            } else if ("2".equals(create)) {
                this.createConnector = 2;
            } else if ("IF_NEEDED".equals(create)) {
                this.createConnector = 0;
            } else if ("ALWAYS".equals(create)) {
                this.createConnector = 1;
            } else if ("NEVER".equals(create)) {
                this.createConnector = 2;
            } else if (this.connectorName == null) {
                this.createConnector = 3;
                this.connectorName = create;
            }
        }
        this.transformers = (String)properties.get("transformers");
        if (this.transformers != null) {
            this.transformers = this.transformers.replaceAll(" ", ",");
        }
        this.responseTransformers = (String)properties.get("responseTransformers");
        if (this.responseTransformers != null) {
            this.responseTransformers = this.responseTransformers.replaceAll(" ", ",");
        }
        this.userInfo = uri.getUserInfo();
        if (this.userInfo != null) {
            this.userInfo = this.decode(this.userInfo, uri);
        }
        return properties;
    }

    private String decode(String string, URI uri) throws MalformedEndpointException {
        try {
            return URLDecoder.decode(string, MuleManager.getConfiguration().getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new MalformedEndpointException(uri.toString(), (Throwable)e);
        }
    }
}

