/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.impl.NoSatisfiableMethodsException;
import org.mule.impl.RequestContext;
import org.mule.impl.TooManySatisfiableMethodsException;
import org.mule.impl.UMODescriptorAware;
import org.mule.impl.VoidResult;
import org.mule.impl.model.resolvers.DynamicEntryPoint;
import org.mule.impl.model.resolvers.DynamicEntryPointResolver;
import org.mule.routing.nested.NestedInvocationHandler;
import org.mule.umo.ComponentException;
import org.mule.umo.Invocation;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Startable;
import org.mule.umo.lifecycle.Stoppable;
import org.mule.umo.lifecycle.UMOLifecycleAdapter;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.umo.routing.UMONestedRouter;
import org.mule.util.ClassUtils;

public class DefaultLifecycleAdapter
implements UMOLifecycleAdapter {
    protected static final Log logger = LogFactory.getLog((Class)DefaultLifecycleAdapter.class);
    private Object component;
    private UMODescriptor descriptor;
    private boolean isStoppable = false;
    private boolean isStartable = false;
    private boolean isDisposable = false;
    private boolean started = false;
    private boolean disposed = false;
    private DynamicEntryPoint entryPoint;

    public DefaultLifecycleAdapter(Object component, UMODescriptor descriptor) throws UMOException {
        this(component, descriptor, new DynamicEntryPointResolver());
    }

    public DefaultLifecycleAdapter(Object component, UMODescriptor descriptor, UMOEntryPointResolver epResolver) throws UMOException {
        this.initialise(component, descriptor, epResolver);
    }

    protected void initialise(Object component, UMODescriptor descriptor, UMOEntryPointResolver epDiscovery) throws UMOException {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        if (epDiscovery == null) {
            epDiscovery = new DynamicEntryPointResolver();
        }
        this.component = component;
        this.entryPoint = (DynamicEntryPoint)epDiscovery.resolveEntryPoint(descriptor);
        this.descriptor = descriptor;
        this.isStartable = Startable.class.isInstance(component);
        this.isStoppable = Stoppable.class.isInstance(component);
        this.isDisposable = Disposable.class.isInstance(component);
        if (component instanceof UMODescriptorAware) {
            ((UMODescriptorAware)component).setDescriptor(descriptor);
        }
        this.configureNestedRouter();
    }

    public void start() throws UMOException {
        if (this.isStartable) {
            try {
                ((Startable)this.component).start();
            }
            catch (Exception e) {
                throw new MuleException(CoreMessages.failedToStart("UMO Component: " + this.descriptor.getName()), (Throwable)e);
            }
        }
        this.started = true;
    }

    public void stop() throws UMOException {
        if (this.isStoppable) {
            try {
                ((Stoppable)this.component).stop();
            }
            catch (Exception e) {
                throw new MuleException(CoreMessages.failedToStop("UMO Component: " + this.descriptor.getName()), (Throwable)e);
            }
        }
        this.started = false;
    }

    public void dispose() {
        if (this.isDisposable) {
            try {
                ((Disposable)this.component).dispose();
            }
            catch (Exception e) {
                logger.error((Object)("failed to dispose: " + this.descriptor.getName()), (Throwable)e);
            }
        }
        this.disposed = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public UMODescriptor getDescriptor() {
        return this.descriptor;
    }

    public void handleException(Object message, Exception e) {
        this.descriptor.getExceptionListener().exceptionThrown(e);
    }

    public UMOMessage intercept(Invocation invocation) throws UMOException {
        Object result;
        UMOEvent event = RequestContext.getEvent();
        try {
            result = this.entryPoint.invoke(this.component, RequestContext.getEventContext());
        }
        catch (Exception e) {
            throw new ComponentException(CoreMessages.failedToInvoke(this.component.getClass().getName()), invocation.getMessage(), event.getComponent(), e);
        }
        UMOMessage resultMessage = null;
        if (result instanceof VoidResult) {
            resultMessage = new MuleMessage(event.getTransformedMessage(), RequestContext.getEventContext().getMessage());
        } else if (result != null) {
            resultMessage = result instanceof UMOMessage ? (UMOMessage)result : new MuleMessage(result, event.getMessage());
        }
        return resultMessage;
    }

    public void initialise() throws InitialisationException {
        if (Initialisable.class.isInstance(this.component)) {
            ((Initialisable)this.component).initialise();
        }
    }

    protected void configureNestedRouter() throws UMOException {
        if (this.descriptor.getNestedRouter() != null) {
            HashMap bindings = new HashMap();
            Iterator it = this.descriptor.getNestedRouter().getRouters().iterator();
            while (it.hasNext()) {
                UMONestedRouter nestedRouter = (UMONestedRouter)it.next();
                Object proxy = bindings.get(nestedRouter.getInterface());
                if (proxy == null) {
                    proxy = nestedRouter.createProxy(this.component);
                    bindings.put(nestedRouter.getInterface(), proxy);
                    List methods = ClassUtils.getSatisfiableMethods(this.component.getClass(), new Class[]{nestedRouter.getInterface()}, true, false, null);
                    if (methods.size() != 1) {
                        if (methods.size() > 1) {
                            throw new TooManySatisfiableMethodsException(this.component.getClass(), new Class[]{nestedRouter.getInterface()});
                        }
                        throw new NoSatisfiableMethodsException(this.component.getClass(), nestedRouter.getInterface());
                    }
                    Method setterMethod = (Method)methods.get(0);
                    try {
                        setterMethod.invoke(this.component, proxy);
                        continue;
                    }
                    catch (Exception e) {
                        throw new InitialisationException(CoreMessages.failedToSetProxyOnService(nestedRouter, this.component.getClass()), e, this);
                    }
                }
                NestedInvocationHandler handler = (NestedInvocationHandler)Proxy.getInvocationHandler(proxy);
                handler.addRouterForInterface(nestedRouter);
            }
        }
    }
}

