/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;

public abstract class MessageFactory {
    private static final Log logger = LogFactory.getLog((Class)MessageFactory.class);
    private static final int STATIC_ERROR_CODE = -1;
    private static final transient Object[] EMPTY_ARGS = new Object[0];

    protected static String getBundlePath(String bundleName) {
        return "META-INF.services.org.mule.i18n." + bundleName + "-messages";
    }

    protected static Message createMessage(String bundlePath, int code, Object arg) {
        Object[] arguments = new Object[]{arg};
        String messageString = MessageFactory.getString(bundlePath, code, arguments);
        return new Message(messageString, code, arguments);
    }

    protected static Message createMessage(String bundlePath, int code, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        String messageString = MessageFactory.getString(bundlePath, code, arguments);
        return new Message(messageString, code, arguments);
    }

    protected static Message createMessage(String bundlePath, int code, Object arg1, Object arg2, Object arg3) {
        Object[] arguments = new Object[]{arg1, arg2, arg3};
        String messageString = MessageFactory.getString(bundlePath, code, arguments);
        return new Message(messageString, code, arguments);
    }

    protected static Message createMessage(String bundlePath, int code) {
        String messageString = MessageFactory.getString(bundlePath, code, null);
        return new Message(messageString, code, EMPTY_ARGS);
    }

    public static Message createStaticMessage(String message) {
        return new Message(message, -1, EMPTY_ARGS);
    }

    protected static String getString(String bundlePath, int code) {
        return MessageFactory.getString(bundlePath, code, null);
    }

    protected static String getString(String bundlePath, int code, Object arg) {
        Object[] arguments = new Object[]{arg};
        return MessageFactory.getString(bundlePath, code, arguments);
    }

    protected static String getString(String bundlePath, int code, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return MessageFactory.getString(bundlePath, code, arguments);
    }

    protected static String getString(String bundlePath, int code, Object[] args) {
        ResourceBundle bundle = MessageFactory.getBundle(bundlePath);
        try {
            String m = bundle.getString(String.valueOf(code));
            if (m == null) {
                logger.error((Object)("Failed to find message for id " + code + " in resource bundle " + bundlePath));
                return "";
            }
            return MessageFormat.format(m, args);
        }
        catch (MissingResourceException e) {
            logger.error((Object)("Failed to find message for id " + code + " in resource bundle " + bundlePath));
            return "";
        }
    }

    private static ResourceBundle getBundle(String bundlePath) {
        Locale locale = Locale.getDefault();
        logger.debug((Object)("Loading resource bundle: " + bundlePath + " for locale " + locale));
        ResourceBundle bundle = ResourceBundle.getBundle(bundlePath, locale);
        return bundle;
    }
}

