/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.simple;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;

public class MessagePropertiesTransformer
extends AbstractEventAwareTransformer {
    private Set deleteProperties = null;
    private Map addProperties = null;
    private boolean overwrite = true;

    public MessagePropertiesTransformer() {
        this.registerSourceType(Object.class);
        this.setReturnClass(Object.class);
    }

    public Object clone() throws CloneNotSupportedException {
        MessagePropertiesTransformer clone = (MessagePropertiesTransformer)super.clone();
        if (this.deleteProperties != null) {
            clone.setDeleteProperties(new HashSet(this.deleteProperties));
        }
        if (this.addProperties != null) {
            clone.setAddProperties(new HashMap(this.addProperties));
        }
        return clone;
    }

    public Object transform(Object src, String encoding, UMOEventContext context) throws TransformerException {
        UMOMessage message = context.getMessage();
        if (this.deleteProperties != null && this.deleteProperties.size() > 0) {
            Iterator iterator = this.deleteProperties.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                message.removeProperty(o.toString());
            }
        }
        if (this.addProperties != null && this.addProperties.size() > 0) {
            Set propertyNames = message.getPropertyNames();
            Iterator iterator = this.addProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry.getKey() == null) {
                    this.logger.error((Object)"Setting Null property keys is not supported, this entry is being ignored");
                    continue;
                }
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                if (this.overwrite) {
                    if (this.logger.isDebugEnabled() && !propertyNames.contains(key)) {
                        this.logger.debug((Object)("Overwriting message property " + key));
                    }
                    message.setProperty(key, value);
                    continue;
                }
                if (!propertyNames.contains(key) || !this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)MessageFormat.format("Message already contains the property and overwrite is false, skipping: key={0}, value={1}", key, value));
            }
        }
        return src;
    }

    public Set getDeleteProperties() {
        return this.deleteProperties;
    }

    public void setDeleteProperties(Set deleteProperties) {
        this.deleteProperties = deleteProperties;
    }

    public Map getAddProperties() {
        return this.addProperties;
    }

    public void setAddProperties(Map addProperties) {
        this.addProperties = addProperties;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

