/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutePathNotFoundException;
import org.mule.umo.routing.RoutingException;

public class ChainingRouter
extends FilteringOutboundRouter {
    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOMessage resultToReturn = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), message, null);
        }
        int endpointsCount = this.endpoints.size();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("About to chain " + endpointsCount + " endpoints."));
        }
        UMOEndpoint endpoint = null;
        try {
            UMOMessage intermediaryResult = message;
            for (int i = 0; i < endpointsCount; ++i) {
                boolean lastEndpointInChain;
                endpoint = this.getEndpoint(i, intermediaryResult);
                boolean bl = lastEndpointInChain = i == endpointsCount - 1;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending Chained message '" + i + "': " + (intermediaryResult == null ? "null" : intermediaryResult.toString())));
                }
                if (!lastEndpointInChain) {
                    UMOMessage localResult = this.send(session, intermediaryResult, endpoint);
                    if (localResult != null && intermediaryResult != null) {
                        this.processIntermediaryResult(localResult, intermediaryResult);
                    }
                    intermediaryResult = localResult;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Received Chain result '" + i + "': " + (intermediaryResult != null ? intermediaryResult.toString() : "null")));
                    }
                    if (intermediaryResult != null) continue;
                    this.logger.warn((Object)("Chaining router cannot process any further endpoints. There was no result returned from endpoint invocation: " + endpoint));
                    break;
                }
                if (synchronous) {
                    resultToReturn = this.send(session, intermediaryResult, endpoint);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Received final Chain result '" + i + "': " + (resultToReturn == null ? "null" : resultToReturn.toString())));
                    continue;
                }
                resultToReturn = null;
                this.dispatch(session, intermediaryResult, endpoint);
            }
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(message, endpoint, (Throwable)e);
        }
        return resultToReturn;
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        if (!endpoint.isRemoteSync()) {
            this.logger.debug((Object)("Endpoint: " + endpoint.getEndpointURI() + " registered on chaining router needs to be RemoteSync enabled. Setting this property now"));
            endpoint.setRemoteSync(true);
        }
        super.addEndpoint(endpoint);
    }

    protected void processIntermediaryResult(UMOMessage localResult, UMOMessage intermediaryResult) {
        localResult.setCorrelationId(intermediaryResult.getCorrelationId());
        localResult.setCorrelationSequence(intermediaryResult.getCorrelationSequence());
        localResult.setCorrelationGroupSize(intermediaryResult.getCorrelationGroupSize());
        localResult.setReplyTo(intermediaryResult.getReplyTo());
    }
}

