/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.streaming;

import java.util.Iterator;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.RequestContext;
import org.mule.impl.model.AbstractComponent;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.model.UMOEntryPoint;
import org.mule.umo.model.UMOModel;

public class StreamingComponent
extends AbstractComponent {
    private static final long serialVersionUID = 2967438446264425730L;
    protected Object component;
    protected UMOEntryPoint entryPoint;

    public StreamingComponent(MuleDescriptor descriptor, UMOModel model) {
        super(descriptor, model);
    }

    protected void doInitialise() throws InitialisationException {
        try {
            this.component = this.lookupComponent();
        }
        catch (UMOException e) {
            throw new InitialisationException(e, (Object)this);
        }
        Iterator iterator = this.descriptor.getInboundRouter().getEndpoints().iterator();
        while (iterator.hasNext()) {
            UMOImmutableEndpoint ep = (UMOImmutableEndpoint)iterator.next();
            if (!ep.isStreaming()) {
                throw new InitialisationException(CoreMessages.streamingEndpointsMustBeUsedWithStreamingModel(), (Object)this);
            }
            if (ep.getTransformer() == null) continue;
            throw new InitialisationException(CoreMessages.streamingEndpointsDoNotSupportTransformers(), (Object)this);
        }
        if (this.component instanceof Initialisable) {
            ((Initialisable)this.component).initialise();
        }
        try {
            this.entryPoint = this.model.getEntryPointResolver().resolveEntryPoint(this.descriptor);
        }
        catch (Exception e) {
            throw new InitialisationException(e, (Object)this);
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws UMOException {
        this.doDispatch(event);
        return null;
    }

    protected void doDispatch(UMOEvent event) throws UMOException {
        try {
            this.entryPoint.invoke(this.component, RequestContext.getEventContext());
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
    }

    protected void doDispose() {
        if (this.component instanceof Disposable) {
            ((Disposable)this.component).dispose();
        }
    }
}

