/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSessionHandler;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.providers.AbstractConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.EndpointNotFoundException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOSessionHandler;
import org.mule.umo.routing.UMOOutboundRouterCollection;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.util.UUID;

public final class MuleSession
implements UMOSession {
    private static final long serialVersionUID = 3380926585676521866L;
    private static Log logger = LogFactory.getLog((Class)MuleSession.class);
    private UMOComponent component = null;
    private boolean valid = true;
    private String id;
    private UMOSecurityContext securityContext;
    private Map properties = null;

    public MuleSession(UMOComponent component) {
        this.properties = new HashMap();
        this.id = UUID.getUUID();
        this.component = component;
    }

    public MuleSession(UMOMessage message, UMOSessionHandler requestSessionHandler, UMOComponent component) throws UMOException {
        this(message, requestSessionHandler);
        if (component == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("component").toString());
        }
        this.component = component;
    }

    public MuleSession(UMOMessage message, UMOSessionHandler requestSessionHandler) throws UMOException {
        if (requestSessionHandler == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("requestSessionHandler").toString());
        }
        if (message == null) {
            throw new IllegalArgumentException(CoreMessages.propertiesNotSet("message").toString());
        }
        this.properties = new HashMap();
        requestSessionHandler.retrieveSessionInfoFromMessage(message, this);
        this.id = (String)this.getProperty(requestSessionHandler.getSessionIDKey());
        if (this.id == null) {
            this.id = UUID.getUUID();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("There is no session id on the request using key: " + requestSessionHandler.getSessionIDKey() + ". Generating new session id: " + this.id));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got session with id: " + this.id));
        }
    }

    public void dispatchEvent(UMOMessage message) throws UMOException {
        if (this.component == null) {
            throw new IllegalStateException(CoreMessages.objectIsNull("Component").getMessage());
        }
        UMOOutboundRouterCollection router = this.component.getDescriptor().getOutboundRouter();
        if (router == null) {
            throw new EndpointNotFoundException(CoreMessages.noOutboundRouterSetOn(this.component.getDescriptor().getName()));
        }
        router.route(message, this, false);
    }

    public void dispatchEvent(UMOMessage message, String endpointName) throws UMOException {
        this.dispatchEvent(message, MuleManager.getInstance().lookupEndpoint(endpointName));
    }

    public void dispatchEvent(UMOMessage message, UMOImmutableEndpoint endpoint) throws UMOException {
        if (endpoint == null) {
            logger.warn((Object)"Endpoint argument is null, using outbound router to determine endpoint.");
            this.dispatchEvent(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session has received asynchronous event on: " + endpoint));
        }
        UMOEvent event = this.createOutboundEvent(message, endpoint, null);
        this.dispatchEvent(event);
        RequestContext.writeResponse(event.getMessage());
        this.processResponse(event.getMessage());
    }

    public UMOMessage sendEvent(UMOMessage message, String endpointName) throws UMOException {
        return this.sendEvent(message, MuleManager.getInstance().lookupEndpoint(endpointName));
    }

    public UMOMessage sendEvent(UMOMessage message) throws UMOException {
        if (this.component == null) {
            throw new IllegalStateException(CoreMessages.objectIsNull("Component").getMessage());
        }
        UMOOutboundRouterCollection router = this.component.getDescriptor().getOutboundRouter();
        if (router == null) {
            throw new EndpointNotFoundException(CoreMessages.noOutboundRouterSetOn(this.component.getDescriptor().getName()));
        }
        UMOMessage result = router.route(message, this, true);
        if (result != null) {
            RequestContext.writeResponse(result);
            this.processResponse(result);
        }
        return result;
    }

    public UMOMessage sendEvent(UMOMessage message, UMOImmutableEndpoint endpoint) throws UMOException {
        if (endpoint == null) {
            logger.warn((Object)"Endpoint argument is null, using outbound router to determine endpoint.");
            return this.sendEvent(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Session has received synchronous event on endpoint: " + endpoint));
        }
        UMOEvent event = this.createOutboundEvent(message, endpoint, null);
        UMOMessage result = this.sendEvent(event);
        if (endpoint.isRemoteSync() && endpoint.getResponseTransformer() != null && result != null) {
            Object response = endpoint.getResponseTransformer().transform(result.getPayload());
            result = new MuleMessage(response, result);
        }
        if (result != null) {
            RequestContext.writeResponse(result);
            this.processResponse(result);
        }
        return result;
    }

    public void dispatchEvent(UMOEvent event) throws UMOException {
        if (event.getEndpoint().canSend()) {
            try {
                UMOConnector connector;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("dispatching event: " + event));
                }
                if ((connector = event.getEndpoint().getConnector()) instanceof AbstractConnector) {
                    ((AbstractConnector)connector).getSessionHandler().storeSessionInfoToMessage(this, event.getMessage());
                } else {
                    logger.warn((Object)"A session handler could not be obtained, using  default");
                    new MuleSessionHandler().storeSessionInfoToMessage(this, event.getMessage());
                }
                event.getEndpoint().dispatch(event);
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        } else if (this.component != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dispatching event to component: " + this.component.getDescriptor().getName() + ", event is: " + event));
            }
            this.component.dispatchEvent(event);
            RequestContext.writeResponse(event.getMessage());
            this.processResponse(event.getMessage());
        } else {
            throw new DispatchException(CoreMessages.noComponentForEndpoint(), event.getMessage(), event.getEndpoint());
        }
    }

    public String getId() {
        return this.id;
    }

    public UMOMessage sendEvent(UMOEvent event) throws UMOException {
        int timeout = event.getMessage().getIntProperty("MULE_EVENT_TIMEOUT", -1);
        if (timeout >= 0) {
            event.setTimeout(timeout);
        }
        if (event.getEndpoint().canSend()) {
            try {
                UMOConnector connector;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sending event: " + event));
                }
                if ((connector = event.getEndpoint().getConnector()) instanceof AbstractConnector) {
                    ((AbstractConnector)connector).getSessionHandler().storeSessionInfoToMessage(this, event.getMessage());
                } else {
                    logger.warn((Object)"A session handler could not be obtained, using default.");
                    new MuleSessionHandler().storeSessionInfoToMessage(this, event.getMessage());
                }
                UMOMessage response = event.getEndpoint().send(event);
                RequestContext.writeResponse(response);
                this.processResponse(response);
                return response;
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        if (this.component != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dispatching event to component: " + this.component.getDescriptor().getName() + " event is: " + event));
            }
            return this.component.sendEvent(event);
        }
        throw new DispatchException(CoreMessages.noComponentForEndpoint(), event.getMessage(), event.getEndpoint());
    }

    protected void processResponse(UMOMessage response) {
        if (response == null) {
            return;
        }
        response.removeProperty("method");
        response.removeProperty("MULE_REMOTE_SYNC");
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean value) {
        this.valid = value;
    }

    public UMOMessage receiveEvent(String endpointName, long timeout) throws UMOException {
        UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri(endpointName, "receiver");
        return this.receiveEvent(endpoint, timeout);
    }

    public UMOMessage receiveEvent(UMOImmutableEndpoint endpoint, long timeout) throws UMOException {
        try {
            return endpoint.receive(timeout);
        }
        catch (Exception e) {
            throw new ReceiveException(endpoint, timeout, e);
        }
    }

    public UMOEvent createOutboundEvent(UMOMessage message, UMOImmutableEndpoint endpoint, UMOEvent previousEvent) throws UMOException {
        if (endpoint == null) {
            throw new DispatchException(CoreMessages.objectIsNull("Outbound Endpoint"), message, endpoint);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating event with data: " + message.getPayload().getClass().getName() + ", for endpoint: " + endpoint));
        }
        if (endpoint.getTransformer() == null && endpoint instanceof UMOEndpoint && endpoint.getConnector() instanceof AbstractConnector) {
            ((UMOEndpoint)endpoint).setTransformer(((AbstractConnector)endpoint.getConnector()).getDefaultOutboundTransformer());
            logger.debug((Object)("Using default connector outbound transformer: " + endpoint.getTransformer()));
        }
        try {
            MuleEvent event = previousEvent != null ? new MuleEvent(message, endpoint, this.component, previousEvent) : new MuleEvent(message, endpoint, (UMOSession)this, false, null);
            return event;
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToCreate("Event"), message, endpoint, e);
        }
    }

    public UMOComponent getComponent() {
        return this.component;
    }

    void setComponent(UMOComponent component) {
        this.component = component;
    }

    public void setSecurityContext(UMOSecurityContext context) {
        this.securityContext = context;
    }

    public UMOSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public Object removeProperty(Object key) {
        return this.properties.remove(key);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }
}

