/*
 * Decompiled with CFR 0.152.
 */
package org.mule.components.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.components.rest.RestServiceException;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.NullPayload;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.properties.MessagePropertyExtractor;
import org.mule.util.properties.PropertyExtractor;

public class RestServiceWrapper
implements Callable,
Initialisable {
    public static final String REST_SERVICE_URL = "rest.service.url";
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String serviceUrl;
    private boolean urlFromMessage = false;
    private Map requiredParams = new HashMap();
    private Map optionalParams = new HashMap();
    private String httpMethod = "GET";
    private String payloadParameterName;
    private UMOFilter errorFilter;
    private String errorExpression;
    private PropertyExtractor propertyExtractor = new MessagePropertyExtractor();

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public boolean isUrlFromMessage() {
        return this.urlFromMessage;
    }

    public void setUrlFromMessage(boolean urlFromMessage) {
        this.urlFromMessage = urlFromMessage;
    }

    public Map getRequiredParams() {
        return this.requiredParams;
    }

    public void setRequiredParams(Map requiredParams) {
        this.requiredParams = requiredParams;
    }

    public Map getOptionalParams() {
        return this.optionalParams;
    }

    public void setOptionalParams(Map optionalParams) {
        this.optionalParams = optionalParams;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getPayloadParameterName() {
        return this.payloadParameterName;
    }

    public void setPayloadParameterName(String payloadParameterName) {
        this.payloadParameterName = payloadParameterName;
    }

    public UMOFilter getErrorFilter() {
        return this.errorFilter;
    }

    public void setErrorFilter(UMOFilter errorFilter) {
        this.errorFilter = errorFilter;
    }

    public String getErrorExpression() {
        return this.errorExpression;
    }

    public void setErrorExpression(String errorExpression) {
        this.errorExpression = errorExpression;
    }

    public void initialise() throws InitialisationException {
        if (this.serviceUrl == null && !this.urlFromMessage) {
            throw new InitialisationException(CoreMessages.objectIsNull("serviceUrl"), (Object)this);
        }
        if (this.serviceUrl != null) {
            try {
                new URL(this.serviceUrl);
            }
            catch (MalformedURLException e) {
                throw new InitialisationException(e, (Object)this);
            }
        }
        if (this.errorFilter == null) {
            if (this.errorExpression == null) {
                this.errorFilter = new MessagePropertyFilter("http.status!=200");
                this.logger.info((Object)"Setting default error filter to MessagePropertyFilter('http.status!=200')");
            } else {
                this.errorFilter = new RegExFilter(this.errorExpression);
            }
        }
    }

    public Object onCall(UMOEventContext eventContext) throws Exception {
        String tempUrl;
        Object request;
        Object requestBody = request = eventContext.getTransformedMessage();
        if (this.urlFromMessage) {
            tempUrl = eventContext.getMessage().getStringProperty(REST_SERVICE_URL, null);
            if (tempUrl == null) {
                throw new IllegalArgumentException(CoreMessages.propertyIsNotSetOnEvent(REST_SERVICE_URL).toString());
            }
        } else {
            tempUrl = this.serviceUrl;
        }
        StringBuffer urlBuffer = new StringBuffer(tempUrl);
        if (this.payloadParameterName != null) {
            requestBody = NullPayload.getInstance();
        } else if (request instanceof Map) {
            requestBody = NullPayload.getInstance();
        }
        this.setRESTParams(urlBuffer, eventContext.getMessage(), request, this.requiredParams, false);
        this.setRESTParams(urlBuffer, eventContext.getMessage(), request, this.optionalParams, true);
        tempUrl = urlBuffer.toString();
        this.logger.info((Object)("Invoking REST service: " + tempUrl));
        MuleEndpointURI endpointURI = new MuleEndpointURI(tempUrl);
        eventContext.getMessage().setProperty("http.method", this.httpMethod);
        UMOMessage result = eventContext.sendEvent((UMOMessage)new MuleMessage(requestBody, eventContext.getMessage()), endpointURI);
        if (this.isErrorPayload(result)) {
            this.handleException(new RestServiceException(CoreMessages.failedToInvokeRestService(tempUrl), result), result);
        }
        return result;
    }

    private void setRESTParams(StringBuffer url, UMOMessage msg, Object body, Map args, boolean optional) {
        int sep = url.indexOf("?") > -1 ? 38 : 63;
        Iterator iterator = args.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            String exp = (String)entry.getValue();
            Object value = this.propertyExtractor.getProperty(exp, msg);
            if (value == null) {
                if (optional) continue;
                throw new IllegalArgumentException(CoreMessages.propertyIsNotSetOnEvent(exp).toString());
            }
            url.append((char)sep);
            sep = 38;
            url.append(name).append('=').append(value);
        }
        if (!optional && this.payloadParameterName != null) {
            url.append((char)sep).append(this.payloadParameterName).append('=').append(body.toString());
        }
    }

    protected boolean isErrorPayload(UMOMessage message) {
        if (this.errorFilter != null) {
            return this.errorFilter.accept(message);
        }
        return false;
    }

    protected void handleException(RestServiceException e, UMOMessage result) throws Exception {
        throw e;
    }
}

